/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.sms;

import com.tydic.nbchat.user.api.NbChatSmsHelper;
import com.tydic.nbchat.user.api.bo.SendBatchSmsRequest;
import com.tydic.nbchat.user.api.bo.SendSmsRequest;
import com.tydic.nbchat.user.api.bo.eums.SmsHelperType;
import com.tydic.nbchat.user.core.utils.SendSmsUtils;
import com.tydic.nbchat.user.core.utils.SmsRedisUtils;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EtongSmsHelperImpl
implements NbChatSmsHelper {
    private static final Logger log = LoggerFactory.getLogger(EtongSmsHelperImpl.class);
    private final SmsRedisUtils smsRedisUtils;

    public EtongSmsHelperImpl(SmsRedisUtils smsRedisUtils) {
        this.smsRedisUtils = smsRedisUtils;
    }

    public String type() {
        return SmsHelperType.ETONG.getCode();
    }

    @MethodParamVerifyEnable
    public Rsp sendSms(SendSmsRequest sendSmsRequest) {
        log.info("\u77ed\u4fe1\u53d1\u9001-\u5f00\u59cb:{}", (Object)sendSmsRequest);
        Map map = sendSmsRequest.getTemplateParam();
        String code = (String)map.get("code");
        boolean result = SendSmsUtils.sendSms(sendSmsRequest.getPhone(), code);
        if (result) {
            log.info("\u77ed\u4fe1\u53d1\u9001-\u6210\u529f:{}", (Object)sendSmsRequest);
            if (StringUtils.isNotBlank((CharSequence)sendSmsRequest.getCode())) {
                this.smsRedisUtils.sendSms(sendSmsRequest);
            }
            return BaseRspUtils.createSuccessRsp((Object)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
        }
        log.error("\u77ed\u4fe1\u53d1\u9001-\u5931\u8d25:{}", (Object)sendSmsRequest);
        return BaseRspUtils.createErrorRsp((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
    }

    public RspList<String> sendBatchSms(SendBatchSmsRequest request) {
        throw new DcBusinessException("e\u901a\u8baf\u6e20\u9053\u7fa4\u53d1\u77ed\u4fe1\u63a5\u53e3\u903b\u8f91\u8fd8\u672a\u5f00\u53d1");
    }
}

