/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.sms;

import com.tydic.nbchat.user.core.config.SmsTemplateProperties;
import com.tydic.nbchat.user.core.service.sms.strategy.TemplateStrategy;
import com.tydic.nbchat.user.core.service.sms.strategy.TemplateStrategyFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmsTemplateService {
    private static final Logger log = LoggerFactory.getLogger(SmsTemplateService.class);
    private final SmsTemplateProperties smsTemplateProperties;
    private final TemplateStrategyFactory strategyFactory;
    private final Map<String, String> templateCodeToIdMap = new ConcurrentHashMap<String, String>();

    public SmsTemplateService(SmsTemplateProperties smsTemplateProperties, TemplateStrategyFactory strategyFactory) {
        this.smsTemplateProperties = smsTemplateProperties;
        this.strategyFactory = strategyFactory;
    }

    @PostConstruct
    public void init() {
        this.smsTemplateProperties.getDefaultTemplates().forEach((templateCode, templateId) -> this.templateCodeToIdMap.put((String)templateCode, (String)templateId));
        Map<String, String> chinaTplMap = this.smsTemplateProperties.getAreaCodes().get("86");
        if (chinaTplMap != null && !chinaTplMap.isEmpty()) {
            this.templateCodeToIdMap.putAll(chinaTplMap);
        }
        log.info("\u77ed\u4fe1\u6a21\u677f\u670d\u52a1\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6a21\u677f\u4ee3\u7801\u6570\u91cf: {}", (Object)this.templateCodeToIdMap.size());
    }

    public String getDefaultTemplateId(String templateCode) {
        TemplateStrategy defaultStrategy = this.strategyFactory.getStrategy("86");
        return defaultStrategy.getTemplateId(templateCode);
    }

    public String getTemplateIdByAreaCode(String areaCode, String templateCode) {
        if (StringUtils.isBlank((CharSequence)areaCode) || StringUtils.isBlank((CharSequence)templateCode)) {
            log.debug("\u77ed\u4fe1\u6a21\u677f\u670d\u52a1-\u53c2\u6570\u4e3a\u7a7a: areaCode={}, templateCode={}", (Object)areaCode, (Object)templateCode);
            return templateCode;
        }
        TemplateStrategy strategy = this.strategyFactory.getStrategy(areaCode);
        String templateId = strategy.getTemplateId(templateCode);
        if (!templateCode.equals(templateId)) {
            log.debug("\u77ed\u4fe1\u6a21\u677f\u670d\u52a1-\u533a\u53f7\u7279\u5b9a\u6a21\u677f\u6620\u5c04: \u533a\u53f7={}, \u6a21\u677f\u4ee3\u7801={} -> \u6a21\u677fID={}", new Object[]{areaCode, templateCode, templateId});
        } else {
            log.debug("\u77ed\u4fe1\u6a21\u677f\u670d\u52a1-\u4f7f\u7528\u9ed8\u8ba4\u6a21\u677f: \u533a\u53f7={}, \u6a21\u677f\u4ee3\u7801={}", (Object)areaCode, (Object)templateCode);
        }
        return templateId;
    }

    public String getTemplateCode(String templateIdOrCode) {
        if (this.templateCodeToIdMap.containsKey(templateIdOrCode)) {
            return templateIdOrCode;
        }
        for (Map.Entry<String, String> entry : this.templateCodeToIdMap.entrySet()) {
            if (!entry.getValue().equals(templateIdOrCode)) continue;
            return entry.getKey();
        }
        return templateIdOrCode;
    }
}

