/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.sms.strategy;

import com.tydic.nbchat.user.api.bo.eums.SmsTemplateEnum;
import com.tydic.nbchat.user.core.service.sms.strategy.TemplateStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AreaCodeTemplateStrategy
implements TemplateStrategy {
    private static final Logger log = LoggerFactory.getLogger(AreaCodeTemplateStrategy.class);
    private final String areaCode;
    private final Map<String, String> templateCodeToIdMap;
    private final TemplateStrategy fallbackStrategy;
    private final Map<String, Map<String, String>> areaCodeTemplateMap = new ConcurrentHashMap<String, Map<String, String>>();

    public AreaCodeTemplateStrategy() {
        this.areaCode = null;
        this.templateCodeToIdMap = new ConcurrentHashMap<String, String>();
        this.fallbackStrategy = null;
    }

    public AreaCodeTemplateStrategy(String areaCode, Map<String, String> templates, TemplateStrategy fallbackStrategy) {
        this.areaCode = areaCode;
        this.templateCodeToIdMap = new ConcurrentHashMap<String, String>(templates);
        this.fallbackStrategy = fallbackStrategy;
    }

    @PostConstruct
    public void init() {
        HashMap<String, String> hkTemplateMap = new HashMap<String, String>();
        hkTemplateMap.put(SmsTemplateEnum.LOGIN.getTemplateID(), SmsTemplateEnum.LOGIN.getInternationalTemplateID());
        hkTemplateMap.put(SmsTemplateEnum.TENANT_APPLY.getTemplateID(), SmsTemplateEnum.TENANT_APPLY.getInternationalTemplateID());
        hkTemplateMap.put(SmsTemplateEnum.VIP_OPEN.getTemplateID(), SmsTemplateEnum.VIP_OPEN.getInternationalTemplateID());
        hkTemplateMap.put(SmsTemplateEnum.VIP_CLOSE.getTemplateID(), SmsTemplateEnum.VIP_CLOSE.getInternationalTemplateID());
        hkTemplateMap.put(SmsTemplateEnum.VIP_RENEW.getTemplateID(), SmsTemplateEnum.VIP_RENEW.getInternationalTemplateID());
        this.areaCodeTemplateMap.put("852", hkTemplateMap);
        log.info("\u533a\u53f7\u6a21\u677f\u7b56\u7565\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u652f\u6301\u7684\u533a\u53f7\u6570\u91cf: {}", (Object)this.areaCodeTemplateMap.size());
    }

    public String getTemplateId(String areaCode, String originalTemplateId) {
        if (StringUtils.isBlank((CharSequence)areaCode) || StringUtils.isBlank((CharSequence)originalTemplateId)) {
            return originalTemplateId;
        }
        if ("86".equals(areaCode)) {
            return originalTemplateId;
        }
        Map<String, String> templateMap = this.areaCodeTemplateMap.get(areaCode);
        if (templateMap != null && templateMap.containsKey(originalTemplateId)) {
            String areaSpecificTemplateId = templateMap.get(originalTemplateId);
            log.debug("\u4f7f\u7528\u533a\u53f7\u7279\u5b9a\u6a21\u677f: \u533a\u53f7={}, \u539f\u59cb\u6a21\u677fID={}, \u533a\u53f7\u7279\u5b9a\u6a21\u677fID={}", new Object[]{areaCode, originalTemplateId, areaSpecificTemplateId});
            return areaSpecificTemplateId;
        }
        String internationalTemplateId = SmsTemplateEnum.getInternationalTemplateId((String)originalTemplateId);
        if (StringUtils.isNotBlank((CharSequence)internationalTemplateId)) {
            log.debug("\u4f7f\u7528\u56fd\u9645\u6a21\u677f: \u533a\u53f7={}, \u539f\u59cb\u6a21\u677fID={}, \u56fd\u9645\u6a21\u677fID={}", new Object[]{areaCode, originalTemplateId, internationalTemplateId});
            return internationalTemplateId;
        }
        return originalTemplateId;
    }

    public void addTemplateMapping(String areaCode, String originalTemplateId, String areaSpecificTemplateId) {
        if (StringUtils.isBlank((CharSequence)areaCode) || StringUtils.isBlank((CharSequence)originalTemplateId) || StringUtils.isBlank((CharSequence)areaSpecificTemplateId)) {
            return;
        }
        Map templateMap = this.areaCodeTemplateMap.computeIfAbsent(areaCode, k -> new HashMap());
        templateMap.put(originalTemplateId, areaSpecificTemplateId);
        log.info("\u6dfb\u52a0\u533a\u53f7\u7279\u5b9a\u6a21\u677f\u6620\u5c04: \u533a\u53f7={}, \u539f\u59cb\u6a21\u677fID={}, \u533a\u53f7\u7279\u5b9a\u6a21\u677fID={}", new Object[]{areaCode, originalTemplateId, areaSpecificTemplateId});
    }

    @Override
    public String getTemplateId(String templateCode) {
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            return templateCode;
        }
        if (this.templateCodeToIdMap.containsKey(templateCode)) {
            String templateId = this.templateCodeToIdMap.get(templateCode);
            log.debug("\u4f7f\u7528\u533a\u53f7\u7279\u5b9a\u6a21\u677f: \u533a\u53f7={}, \u6a21\u677f\u4ee3\u7801={}, \u6a21\u677fID={}", new Object[]{this.areaCode, templateCode, templateId});
            return templateId;
        }
        if (this.fallbackStrategy != null) {
            return this.fallbackStrategy.getTemplateId(templateCode);
        }
        return templateCode;
    }

    @Override
    public String getAreaCode() {
        return this.areaCode;
    }

    @Override
    public boolean isApplicable(String areaCode) {
        return StringUtils.isNotBlank((CharSequence)areaCode) && this.areaCode != null && this.areaCode.equals(areaCode);
    }
}

