/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.sms.strategy;

import com.tydic.nbchat.user.core.service.sms.strategy.TemplateStrategy;
import com.tydic.nbchat.user.core.service.sms.strategy.TemplateStrategyDecorator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingTemplateStrategyDecorator
extends TemplateStrategyDecorator {
    private static final Logger log = LoggerFactory.getLogger(CachingTemplateStrategyDecorator.class);
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

    public CachingTemplateStrategyDecorator(TemplateStrategy decoratedStrategy) {
        super(decoratedStrategy);
    }

    @Override
    public String getTemplateId(String templateCode) {
        String cacheKey = this.getAreaCode() + ":" + templateCode;
        if (this.cache.containsKey(cacheKey)) {
            String cachedTemplateId = this.cache.get(cacheKey);
            log.debug("\u4f7f\u7528\u7f13\u5b58\u7684\u6a21\u677fID: \u533a\u53f7={}, \u6a21\u677f\u4ee3\u7801={}, \u6a21\u677fID={}", new Object[]{this.getAreaCode(), templateCode, cachedTemplateId});
            return cachedTemplateId;
        }
        String templateId = this.decoratedStrategy.getTemplateId(templateCode);
        this.cache.put(cacheKey, templateId);
        log.debug("\u7f13\u5b58\u6a21\u677fID: \u533a\u53f7={}, \u6a21\u677f\u4ee3\u7801={}, \u6a21\u677fID={}", new Object[]{this.getAreaCode(), templateCode, templateId});
        return templateId;
    }

    public void clearCache() {
        this.cache.clear();
        log.debug("\u6e05\u9664\u6a21\u677fID\u7f13\u5b58");
    }
}

