/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.sms.strategy;

import com.tydic.nbchat.user.core.service.sms.strategy.TemplateStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTemplateStrategy
implements TemplateStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultTemplateStrategy.class);
    private final Map<String, String> templateCodeToIdMap;

    public DefaultTemplateStrategy(Map<String, String> defaultTemplates) {
        this.templateCodeToIdMap = new ConcurrentHashMap<String, String>(defaultTemplates);
    }

    @Override
    public String getTemplateId(String templateCode) {
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            return templateCode;
        }
        return this.templateCodeToIdMap.getOrDefault(templateCode, templateCode);
    }

    @Override
    public String getAreaCode() {
        return "86";
    }

    @Override
    public boolean isApplicable(String areaCode) {
        return StringUtils.isBlank((CharSequence)areaCode) || "86".equals(areaCode);
    }

    public void addTemplateMapping(String templateCode, String templateId) {
        if (StringUtils.isNotBlank((CharSequence)templateCode) && StringUtils.isNotBlank((CharSequence)templateId)) {
            this.templateCodeToIdMap.put(templateCode, templateId);
            log.info("\u6dfb\u52a0\u9ed8\u8ba4\u6a21\u677f\u6620\u5c04: {} -> {}", (Object)templateCode, (Object)templateId);
        }
    }

    public Map<String, String> getTemplateCodeToIdMap() {
        return new ConcurrentHashMap<String, String>(this.templateCodeToIdMap);
    }
}

