/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.sms.strategy;

import com.tydic.nbchat.user.core.config.SmsTemplateProperties;
import com.tydic.nbchat.user.core.service.sms.strategy.AreaCodeTemplateStrategy;
import com.tydic.nbchat.user.core.service.sms.strategy.DefaultTemplateStrategy;
import com.tydic.nbchat.user.core.service.sms.strategy.TemplateStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TemplateStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(TemplateStrategyFactory.class);
    private final SmsTemplateProperties smsTemplateProperties;
    private final Map<String, TemplateStrategy> strategyMap = new ConcurrentHashMap<String, TemplateStrategy>();
    private TemplateStrategy defaultStrategy;

    public TemplateStrategyFactory(SmsTemplateProperties smsTemplateProperties) {
        this.smsTemplateProperties = smsTemplateProperties;
    }

    @PostConstruct
    public void init() {
        this.defaultStrategy = new DefaultTemplateStrategy(this.smsTemplateProperties.getDefaultTemplates());
        this.strategyMap.put("86", this.defaultStrategy);
        log.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u6a21\u677f\u7b56\u7565");
        this.smsTemplateProperties.getAreaCodes().forEach((areaCode, templates) -> {
            if (templates != null && !templates.isEmpty()) {
                AreaCodeTemplateStrategy strategy = new AreaCodeTemplateStrategy((String)areaCode, (Map<String, String>)templates, this.defaultStrategy);
                this.strategyMap.put((String)areaCode, strategy);
                log.info("\u521d\u59cb\u5316\u533a\u53f7\u7279\u5b9a\u6a21\u677f\u7b56\u7565: \u533a\u53f7={}, \u6a21\u677f\u6570\u91cf={}", areaCode, (Object)templates.size());
            }
        });
        log.info("\u6a21\u677f\u7b56\u7565\u5de5\u5382\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u652f\u6301\u7684\u533a\u53f7\u6570\u91cf: {}", (Object)this.strategyMap.size());
    }

    public TemplateStrategy getStrategy(String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return this.defaultStrategy;
        }
        TemplateStrategy strategy = this.strategyMap.get(areaCode = this.normalizeAreaCode(areaCode));
        if (strategy != null) {
            return strategy;
        }
        return this.defaultStrategy;
    }

    public void addStrategy(String areaCode, TemplateStrategy strategy) {
        if (StringUtils.isNotBlank((CharSequence)areaCode) && strategy != null) {
            this.strategyMap.put(areaCode, strategy);
            log.info("\u6dfb\u52a0\u6a21\u677f\u7b56\u7565: \u533a\u53f7={}", (Object)areaCode);
        }
    }

    private String normalizeAreaCode(String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return "86";
        }
        if (StringUtils.isBlank((CharSequence)(areaCode = areaCode.replaceFirst("^0+", "")))) {
            return "86";
        }
        return areaCode;
    }
}

