/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.trade;

import com.tydic.nbchat.user.api.bo.eums.TradeBusiCodeDefine;
import com.tydic.nbchat.user.api.bo.eums.TradePayType;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceAccountReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceDeductReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRechargeReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRefundReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserTradeResult;
import com.tydic.nbchat.user.api.trade.TradeBalanceApi;
import com.tydic.nbchat.user.core.busi.ScoreBalanceService;
import com.tydic.nbchat.user.core.busi.ScoreDeductService;
import com.tydic.nbchat.user.core.busi.ScoreRechargeService;
import com.tydic.nbchat.user.core.busi.ScoreRefundService;
import com.tydic.nbchat.user.core.busi.UserMakeEventSender;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.mapper.CommonMapper;
import com.tydic.nbchat.user.mapper.NbchatUserBalanceMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserBalance;
import com.tydic.nicc.common.nbchat.emus.MakeEventType;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class TradeBalanceServiceImpl
implements TradeBalanceApi {
    private static final Logger log = LoggerFactory.getLogger(TradeBalanceServiceImpl.class);
    @Resource
    private NbchatUserBalanceMapper nbchatUserBalanceMapper;
    @Resource
    private CommonMapper commonMapper;
    private final ScoreBalanceService scoreBalanceService;
    private final ScoreDeductService scoreDeductService;
    private final ScoreRechargeService scoreRechargeService;
    private final ScoreRefundService scoreRefundService;
    private final RedisHelper redisHelper;
    private final UserMakeEventSender userMakeEventSender;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;

    public TradeBalanceServiceImpl(ScoreBalanceService scoreBalanceService, ScoreDeductService scoreDeductService, ScoreRechargeService scoreRechargeService, ScoreRefundService scoreRefundService, RedisHelper redisHelper, UserMakeEventSender userMakeEventSender, NbchatUserConfigProperties nbchatUserConfigProperties) {
        this.scoreBalanceService = scoreBalanceService;
        this.scoreDeductService = scoreDeductService;
        this.scoreRechargeService = scoreRechargeService;
        this.scoreRefundService = scoreRefundService;
        this.redisHelper = redisHelper;
        this.userMakeEventSender = userMakeEventSender;
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
    }

    public Rsp<UserBalanceBO> getBalance(String tenantCode, String userId) {
        if (!this.nbchatUserConfigProperties.getScoreDeductEnable().booleanValue()) {
            UserBalanceBO balance = new UserBalanceBO();
            balance.setUserId(userId);
            balance.setTenantCode(tenantCode);
            balance.setScore(Integer.valueOf(0));
            balance.setDetails(new ArrayList());
            UserBalanceBO tenantBalance = new UserBalanceBO();
            BeanUtils.copyProperties((Object)balance, (Object)tenantBalance);
            balance.setTenantBalance(tenantBalance);
            return BaseRspUtils.createSuccessRsp((Object)balance);
        }
        Rsp<UserBalanceBO> balance = this.scoreBalanceService.getBalance(tenantCode, userId);
        if (balance.isSuccess() && StringUtils.isNotBlank((CharSequence)tenantCode) && !tenantCode.equals(userId)) {
            ((UserBalanceBO)balance.getData()).setTenantBalance((UserBalanceBO)this.scoreBalanceService.getBalance(tenantCode, tenantCode).getData());
        }
        return balance;
    }

    private void sendMakeEvent(UserBalanceDeductReqBO deduct) {
        if (TradeBusiCodeDefine.VIDEO_CREATION.getCode().equals(deduct.getBizCode())) {
            this.userMakeEventSender.sendMakeEvent(deduct.getTenantCode(), deduct.getUserId(), MakeEventType.MAKE_TDH.getCode(), 1, 0);
        } else if (TradeBusiCodeDefine.PPT_CREATION.getCode().equals(deduct.getBizCode())) {
            this.userMakeEventSender.sendMakeEvent(deduct.getTenantCode(), deduct.getUserId(), MakeEventType.MAKE_PPT.getCode(), 1, 0);
        } else if (TradeBusiCodeDefine.EXAM_CREATION.getCode().equals(deduct.getBizCode())) {
            this.userMakeEventSender.sendMakeEvent(deduct.getTenantCode(), deduct.getUserId(), MakeEventType.MAKE_EXAM.getCode(), deduct.getAmount(), 0);
        }
    }

    private static UserTradeResult defaultUserTradeResult(String tenantCode, String userId) {
        UserTradeResult userTradeResult = new UserTradeResult();
        userTradeResult.setBalance(new UserBalanceBO());
        userTradeResult.setTenantCode(tenantCode);
        userTradeResult.setUserId(userId);
        userTradeResult.setScore(Integer.valueOf(0));
        userTradeResult.setType("");
        userTradeResult.setRemark("");
        userTradeResult.setBizId("0");
        userTradeResult.setBizCode("0");
        userTradeResult.setBizName("\u9ed8\u8ba4");
        userTradeResult.setPayType("0");
        userTradeResult.setTradeId(NiccCommonUtil.createMsgId());
        userTradeResult.setTradeTime(new Date());
        userTradeResult.setAmount(Integer.valueOf(0));
        userTradeResult.setPrice(Integer.valueOf(0));
        return userTradeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodParamVerifyEnable
    public Rsp<UserTradeResult> deduct(UserBalanceDeductReqBO deduct) {
        if (!this.nbchatUserConfigProperties.getScoreDeductEnable().booleanValue()) {
            return BaseRspUtils.createSuccessRsp((Object)TradeBalanceServiceImpl.defaultUserTradeResult(deduct.getTenantCode(), deduct.getUserId()), (String)"success");
        }
        String key = "nbchat-user:score_deduct:" + deduct.getTenantCode() + ":" + deduct.getUserId();
        RedisLockEntity lockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean lock = this.redisHelper.lockLua(lockEntity, 10L);
        if (lock) {
            try {
                Rsp<UserTradeResult> deductRsp;
                if ("00000000".equals(deduct.getTenantCode())) {
                    deduct.setPayType(TradePayType.PERSONAL.getCode());
                    log.info("\u7b97\u529b\u70b9\u6d88\u8d39[\u4e2a\u4eba]-\u53c2\u6570: {}", (Object)deduct);
                    deductRsp = this.scoreDeductService.deduct(deduct);
                } else if (this.isEnterprisePay(deduct.getTenantCode()).booleanValue()) {
                    deduct.setPayType(TradePayType.ENTERPRISE.getCode());
                    log.info("\u7b97\u529b\u70b9\u6d88\u8d39[\u4f01\u4e1a]-\u53c2\u6570: {}", (Object)deduct);
                    deductRsp = this.scoreDeductService.deduct(deduct);
                } else {
                    deduct.setPayType(TradePayType.PERSONAL.getCode());
                    deductRsp = this.scoreDeductService.deduct(deduct);
                }
                if (deductRsp.isSuccess()) {
                    this.sendMakeEvent(deduct);
                }
                Rsp<UserTradeResult> rsp = deductRsp;
                return rsp;
            }
            catch (Exception e) {
                log.error("\u7b97\u529b\u70b9\u6d88\u8d39-\u5f02\u5e38: {}", (Object)deduct, (Object)e);
            }
            finally {
                this.redisHelper.unlock(lockEntity);
            }
            return BaseRspUtils.createErrorRsp((String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u6263\u51cf\u5f02\u5e38");
        }
        log.warn("\u7b97\u529b\u70b9\u6d88\u8d39-\u83b7\u53d6\u9501\u5931\u8d25: {}", (Object)deduct);
        return BaseRspUtils.createErrorRsp((String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u7cfb\u7edf\u7e41\u5fd9,\u4ea4\u6613\u5931\u8d25");
    }

    public Boolean isEnterprisePay(String tenantCode) {
        String type = this.commonMapper.queryPayType(tenantCode);
        return "0".equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodParamVerifyEnable
    public Rsp<UserTradeResult> tdhTrainDeduct(UserBalanceDeductReqBO deduct) {
        log.info("\u6570\u5b57\u4eba\u5b9a\u5236\u670d\u52a1-\u7b97\u529b\u70b9\u6d88\u8d39[\u4f01\u4e1a]-\u53c2\u6570: {}", (Object)deduct);
        String key = "nbchat-user:score_deduct:" + deduct.getBizId();
        if (deduct.getScore() == null) {
            return BaseRspUtils.createErrorRsp((String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u53c2\u6570\u5f02\u5e38");
        }
        RedisLockEntity lockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean lock = this.redisHelper.lockLua(lockEntity, 10L);
        if (lock) {
            try {
                deduct.setPayType(TradePayType.ENTERPRISE.getCode());
                Rsp<UserTradeResult> rsp = this.scoreDeductService.deduct(deduct);
                return rsp;
            }
            catch (Exception e) {
                log.error("\u6570\u5b57\u4eba\u5b9a\u5236\u670d\u52a1-\u7b97\u529b\u70b9\u6d88\u8d39-\u5f02\u5e38: {}", (Object)deduct, (Object)e);
            }
            finally {
                this.redisHelper.unlock(lockEntity);
            }
            return BaseRspUtils.createErrorRsp((String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u6263\u51cf\u5f02\u5e38");
        }
        log.warn("\u6570\u5b57\u4eba\u5b9a\u5236\u670d\u52a1-\u7b97\u529b\u70b9\u6d88\u8d39-\u83b7\u53d6\u9501\u5931\u8d25: {}", (Object)deduct);
        return BaseRspUtils.createErrorRsp((String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u7cfb\u7edf\u7e41\u5fd9,\u4ea4\u6613\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodParamVerifyEnable
    public Rsp<UserTradeResult> refund(UserBalanceRefundReqBO refund) {
        if (!this.nbchatUserConfigProperties.getScoreDeductEnable().booleanValue()) {
            return BaseRspUtils.createSuccessRsp((Object)TradeBalanceServiceImpl.defaultUserTradeResult(refund.getTenantCode(), refund.get_userId()), (String)"success");
        }
        String key = "nbchat-user:score_refund:" + refund.getTradeId();
        RedisLockEntity lockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean lock = this.redisHelper.lockLua(lockEntity, 10L);
        if (lock) {
            try {
                Rsp<UserTradeResult> rsp = this.scoreRefundService.refund(refund);
                return rsp;
            }
            catch (Exception e) {
                log.error("\u4f59\u989d\u9000\u6b3e-\u5f02\u5e38:{}", (Object)refund, (Object)e);
            }
            finally {
                this.redisHelper.unlock(lockEntity);
            }
            return BaseRspUtils.createErrorRsp((String)"\u9000\u6b3e\u5f02\u5e38");
        }
        return BaseRspUtils.createErrorRsp((String)"\u9000\u6b3e\uff1a\u7cfb\u7edf\u7e41\u5fd9,\u4ea4\u6613\u5931\u8d25");
    }

    @MethodParamVerifyEnable
    public Rsp<Boolean> deductCheck(UserBalanceRechargeReqBO check) {
        if (!this.nbchatUserConfigProperties.getScoreDeductEnable().booleanValue()) {
            return BaseRspUtils.createSuccessRsp((Object)true);
        }
        log.info("\u4f59\u989d\u6821\u9a8c-\u53c2\u6570: {}", (Object)check);
        NbchatUserBalance balance = this.nbchatUserBalanceMapper.selectByTenantCode(check.getTenantCode());
        if (balance == null || check.getScore() > balance.getScore()) {
            log.warn("\u4f59\u989d\u6821\u9a8c-\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u4f59\u989d\u4e0d\u8db3: {}", (Object)check);
            this.nbchatUserBalanceMapper.selectByUserId(check.getTenantCode(), check.getUserId());
        }
        if (balance != null) {
            int score = check.getScore();
            if (score > balance.getScore()) {
                return BaseRspUtils.createSuccessRsp((Object)false, (String)"\u4f59\u989d\u4e0d\u8db3");
            }
            return BaseRspUtils.createSuccessRsp((Object)true);
        }
        return BaseRspUtils.createErrorRsp((Object)false, (String)"\u8d26\u6237\u5f02\u5e38");
    }

    @MethodParamVerifyEnable
    public Rsp<UserTradeResult> recharge(UserBalanceRechargeReqBO recharge) {
        String key = "nbchat-user:score_recharge:" + recharge.getTenantCode() + ":" + recharge.getUserId();
        RedisLockEntity lockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean lock = this.redisHelper.lockLua(lockEntity, 10L);
        if (lock) {
            try {
                return this.scoreRechargeService.recharge(recharge);
            }
            catch (Exception e) {
                log.error("\u7b97\u529b\u70b9\u5145\u503c-\u5f02\u5e38:{}", (Object)recharge, (Object)e);
                return BaseRspUtils.createErrorRsp((String)"\u7b97\u529b\u70b9\u5145\u503c\u5931\u8d25");
            }
        }
        log.warn("\u7b97\u529b\u70b9\u5145\u503c-\u83b7\u53d6\u9501\u5931\u8d25:{}", (Object)recharge);
        return BaseRspUtils.createErrorRsp((String)"\u7b97\u529b\u70b9\u5145\u503c\uff1a\u7cfb\u7edf\u7e41\u5fd9,\u4ea4\u6613\u5931\u8d25");
    }

    public Rsp createBalanceAccount(UserBalanceAccountReqBO accountReqBO) {
        try {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{accountReqBO.getTenantCode(), accountReqBO.getUserId()})) {
                return BaseRspUtils.createErrorRsp((String)"\u521b\u5efa\u8d26\u6237\u53c2\u6570\u5f02\u5e38");
            }
            return this.scoreBalanceService.createBalanceAccount(accountReqBO);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8d26\u6237-\u5f02\u5e38:{}", (Object)accountReqBO, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u521b\u5efa\u8d26\u6237\u5f02\u5e38");
        }
    }
}

