/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.trade;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.user.api.UserBaseInfoApi;
import com.tydic.nbchat.user.api.bo.eums.TradeBusiCodeDefine;
import com.tydic.nbchat.user.api.bo.eums.TradePayType;
import com.tydic.nbchat.user.api.bo.trade.UserBillRecordBO;
import com.tydic.nbchat.user.api.bo.trade.UserBillRecordQueryReqBO;
import com.tydic.nbchat.user.api.bo.user.UserBaseInfo;
import com.tydic.nbchat.user.api.trade.TradeBillRecordApi;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.mapper.NbchatUserBillRecordMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserBillRecordQueryCondition;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class TradeBillRecordServiceImpl
implements TradeBillRecordApi {
    private static final Logger log = LoggerFactory.getLogger(TradeBillRecordServiceImpl.class);
    @Resource
    private NbchatUserBillRecordMapper nbchatUserBillRecordMapper;
    private final UserBaseInfoApi userBaseInfoApi;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;

    public TradeBillRecordServiceImpl(UserBaseInfoApi userBaseInfoApi, NbchatUserConfigProperties nbchatUserConfigProperties) {
        this.userBaseInfoApi = userBaseInfoApi;
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
    }

    @MethodParamVerifyEnable
    public RspList<UserBillRecordBO> getBillRecord(UserBillRecordQueryReqBO queryReqBO) {
        if (!this.nbchatUserConfigProperties.getScoreDeductEnable().booleanValue()) {
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        log.info("\u67e5\u8be2\u7528\u6237\u8d26\u5355\u8bb0\u5f55:{}", (Object)queryReqBO);
        NbchatUserBillRecordQueryCondition condition = new NbchatUserBillRecordQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        if (TradePayType.ENTERPRISE.getCode().equals(queryReqBO.getPayType())) {
            condition.setUserId("");
        }
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.nbchatUserBillRecordMapper.selectByCondition(condition);
        ArrayList list = Lists.newArrayList();
        NiccCommonUtil.copyList((List)page.getResult(), (List)list, UserBillRecordBO.class);
        HashMap<String, UserBaseInfo> userMap = new HashMap<String, UserBaseInfo>();
        for (UserBillRecordBO bill : list) {
            Rsp rsp;
            bill.setBizCodeDesc(TradeBusiCodeDefine.getNameByCode((String)bill.getBizCode()));
            if (!userMap.containsKey(bill.getUserId()) && (rsp = this.userBaseInfoApi.getByUserId(bill.getTenantCode(), bill.getUserId())).isSuccess()) {
                userMap.put(bill.getUserId(), (UserBaseInfo)rsp.getData());
            }
            if (!userMap.containsKey(bill.getUserId())) continue;
            bill.setRealName(((UserBaseInfo)userMap.get(bill.getUserId())).getRealName());
        }
        return BaseRspUtils.createSuccessRspList((List)list, (long)page.getTotal());
    }
}

