/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.timer;

import com.tydic.nbchat.user.core.busi.UserVipRightsService;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="nbchat-user.config", name={"enable-timer"}, havingValue="true", matchIfMissing=true)
@Component
@EnableScheduling
public class UserRightsExpiredTimer {
    private static final Logger log = LoggerFactory.getLogger(UserRightsExpiredTimer.class);
    private final UserVipRightsService userVipRightsService;
    private final RedisHelper redisHelper;

    public UserRightsExpiredTimer(UserVipRightsService userVipRightsService, RedisHelper redisHelper) {
        this.userVipRightsService = userVipRightsService;
        this.redisHelper = redisHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0 1 * * ?")
    public void run() {
        String key = "nbchat-user:expire_lock";
        RedisLockEntity lockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean lock = this.redisHelper.lockLua(lockEntity, 10L);
        if (lock) {
            try {
                this.userVipRightsService.checkRightsExpired();
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u6743\u76ca\u8fc7\u671f\u4efb\u52a1\uff0c\u6267\u884c\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.redisHelper.unlock(lockEntity);
            }
        }
    }
}

