/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.timer;

import com.tydic.nbchat.user.core.busi.ScoreExpiredCheckService;
import com.tydic.nbchat.user.core.busi.VipExpiredCheckService;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="nbchat-user.config", name={"enable-timer"}, havingValue="true", matchIfMissing=true)
@Component
@EnableScheduling
public class UserScoreExpiredTimer {
    private static final Logger log = LoggerFactory.getLogger(UserScoreExpiredTimer.class);
    private final ScoreExpiredCheckService scoreExpiredCheckService;
    private final VipExpiredCheckService vipExpiredCheckService;
    private final RedisHelper redisHelper;

    public UserScoreExpiredTimer(ScoreExpiredCheckService scoreExpiredCheckService, VipExpiredCheckService vipExpiredCheckService, RedisHelper redisHelper) {
        this.scoreExpiredCheckService = scoreExpiredCheckService;
        this.vipExpiredCheckService = vipExpiredCheckService;
        this.redisHelper = redisHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0 0 * * ?")
    public void run() {
        String key = "nbchat-user:score_expired:lock";
        RedisLockEntity lockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean lock = this.redisHelper.lockLua(lockEntity, 10L);
        if (lock) {
            try {
                this.scoreExpiredCheckService.doScoreExpiredCheck(new Date());
                this.vipExpiredCheckService.doVipExpiredCheck(new Date());
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u79ef\u5206\u8fc7\u671f\u4efb\u52a1\uff0c\u6267\u884c\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.redisHelper.unlock(lockEntity);
            }
        }
    }
}

