/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.timer;

import com.tydic.nbchat.user.core.busi.UserScoreRechargeTaskService;
import com.tydic.nbchat.user.core.busi.VipSmsNoticeService;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="nbchat-user.config", name={"enable-timer"}, havingValue="true", matchIfMissing=true)
@Component
@EnableScheduling
public class UserScoreRechargeTimer {
    private static final Logger log = LoggerFactory.getLogger(UserScoreRechargeTimer.class);
    private final UserScoreRechargeTaskService userScoreRechargeTaskService;
    private final RedisHelper redisHelper;
    private final VipSmsNoticeService vipSmsNoticeService;

    public UserScoreRechargeTimer(UserScoreRechargeTaskService userScoreRechargeTaskService, RedisHelper redisHelper, VipSmsNoticeService vipSmsNoticeService) {
        this.userScoreRechargeTaskService = userScoreRechargeTaskService;
        this.redisHelper = redisHelper;
        this.vipSmsNoticeService = vipSmsNoticeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0/5 * * * * ?")
    public void run() {
        String key = "nbchat-user:score_task:lock";
        RedisLockEntity lockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean lock = this.redisHelper.lockLua(lockEntity, 10L);
        if (lock) {
            try {
                this.userScoreRechargeTaskService.doTaskCheck();
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u79ef\u5206\u8fc7\u671f\u4efb\u52a1\uff0c\u6267\u884c\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.redisHelper.unlock(lockEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 30 9 * *  ?")
    public void fun() {
        String key = "nbchat_user_vip_sms_notice_delay_0930_lock_key";
        RedisLockEntity lockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean lock = this.redisHelper.lockLua(lockEntity, 10L);
        if (lock) {
            try {
                this.vipSmsNoticeService.sendDelayNotice();
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u9001\u8c46\u5ef6\u65f6\u901a\u77e5\u4efb\u52a1\uff0c\u6267\u884c\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.redisHelper.unlock(lockEntity);
            }
        }
    }
}

