/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.utils;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.dingtalk.api.response.OapiRobotSendResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DingtalkUtil {
    private static final Logger log = LoggerFactory.getLogger(DingtalkUtil.class);
    static String dingtalkTitle = "";
    static Boolean dingtalkEnable = false;
    static String dingtalkServerUrl = "";
    static Map<String, String> robotSendMap = new HashMap<String, String>();

    DingtalkUtil(NbchatUserConfigProperties nbchatUserConfigProperties) {
        dingtalkTitle = nbchatUserConfigProperties.getDingtalkTitle();
        dingtalkEnable = nbchatUserConfigProperties.getDingtalkEnable();
        dingtalkServerUrl = nbchatUserConfigProperties.getDingtalkServerUrl();
        robotSendMap = nbchatUserConfigProperties.getDingtalkSendMap();
    }

    public static void sendMessageSuggestion(String content, String origin) throws ApiException {
        if (!dingtalkEnable.booleanValue()) {
            log.info("\u3010\u63a8\u9001\u9489\u9489\u7528\u6237\u5efa\u8bae\u6570\u636e\u3011\u4efb\u52a1\u5173\u95ed");
            return;
        }
        log.info("\u9489\u9489\u6d88\u606f\u53d1\u9001\u6d88\u606f\u5185\u5bb9:{}", (Object)content);
        DefaultDingTalkClient client = new DefaultDingTalkClient(dingtalkServerUrl);
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("text");
        OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
        text.setContent(dingtalkTitle + content);
        request.setText(text);
        if (robotSendMap.containsKey(origin)) {
            OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
            at.setAtMobiles(Arrays.asList(robotSendMap.get(origin).split(",")));
            at.setIsAtAll(Boolean.valueOf(false));
            request.setAt(at);
            OapiRobotSendResponse response = (OapiRobotSendResponse)client.execute((TaobaoRequest)request);
            log.info("\u9489\u9489\u6d88\u606f\u53d1\u9001\u6210\u529f:{}", (Object)response.getBody());
        }
    }
}

