/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.utils;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtil {
    private static final Logger log = LoggerFactory.getLogger(EncryptionUtil.class);
    public static final Base64.Encoder encoder = Base64.getEncoder();
    public static final Base64.Decoder decoder = Base64.getDecoder();
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS7Padding";
    public static final String iv = "1234567890123456";
    public static final String AES_KEY = "66vw4aoKSLqmfBM0";
    private static final Pattern encryptPattern = Pattern.compile("@(.*?)@");

    public static String encrypt(byte[] value, String key) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES"));
            byte[] encrypt = cipher.doFinal(value);
            System.out.println(encrypt.length);
            return encoder.encodeToString(encrypt);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5931\u8d25:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] decrypt(byte[] value, String key) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
            cipher.init(2, secretKeySpec);
            return cipher.doFinal(value);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(String value, String key) {
        return EncryptionUtil.encrypt(value.getBytes(StandardCharsets.UTF_8), key);
    }

    public static String decrypt(String value, String key) {
        return new String(Objects.requireNonNull(EncryptionUtil.decrypt(decoder.decode(value), key)), StandardCharsets.UTF_8);
    }

    public static String encrypt(String value) {
        return EncryptionUtil.encrypt(value, AES_KEY);
    }

    public static String decrypt(String value) {
        return EncryptionUtil.decrypt(value, AES_KEY);
    }

    public static String decryptField(String field) {
        if (field.startsWith("@") && field.endsWith("@")) {
            return EncryptionUtil.decrypt(field.replaceAll("@", ""));
        }
        return field;
    }

    public static String decryptBody(String body, String requestUri, String encryptList) {
        List<String> encrypts = List.of(encryptList.split(","));
        if (encrypts.contains(requestUri)) {
            StringBuilder result = new StringBuilder();
            Matcher matcher = encryptPattern.matcher(body);
            while (matcher.find()) {
                try {
                    String encryptedText = matcher.group(1);
                    String decryptedText = EncryptionUtil.decrypt(encryptedText);
                    matcher.appendReplacement(result, decryptedText);
                }
                catch (Exception e) {
                    log.error("\u89e3\u5bc6\u5931\u8d25: err = {} , body = {}", (Object)e.getMessage(), (Object)body);
                }
            }
            matcher.appendTail(result);
            return result.toString();
        }
        return body;
    }

    public static void main(String[] args) {
        String value = "@bjBu7T2GJ1jXZcanbEXeHA==@";
        System.out.println(EncryptionUtil.decryptField(value));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

