/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpRequestUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestUtil.class);

    public static String urlAppendQueryParam(String uri, String name, String param) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)uri).queryParam(name, new Object[]{param});
        return uriBuilder.build(new Object[0]).toString();
    }

    public static String urlAppendQuery(String uri, String queryString) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)uri).encode();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            uriBuilder.query(queryString);
        }
        return uriBuilder.build(new Object[0]).toString();
    }

    public static String urlEncodeQuery(String uri) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)uri).encode();
        return uriBuilder.build(new Object[0]).toString();
    }

    public static String urlEncode(String uri) {
        String encode = "";
        try {
            encode = URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("url\u7f16\u7801\u5f02\u5e38:", (Throwable)e);
        }
        return encode;
    }

    public static String urlDecode(String uri) {
        String decode = "";
        try {
            decode = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("url\u89e3\u7801\u5f02\u5e38:", (Throwable)e);
        }
        return decode;
    }

    public static String getBodyContent(HttpServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (ServletInputStream inputStream = request.getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static void authError(HttpServletResponse response, String error) throws IOException {
        HttpRequestUtil.authError(response, 401, error, "");
    }

    public static void authError(HttpServletResponse response, String error, String redirect) throws IOException {
        HttpRequestUtil.authError(response, 401, error, redirect);
    }

    public static void authError(HttpServletResponse response, int code, String error, String redirect) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        response.setStatus(code);
        if (StringUtils.isNotBlank((CharSequence)redirect)) {
            response.setHeader("redirectUrl", redirect);
            response.setHeader("enableRedirect", "true");
        }
        PrintWriter out = response.getWriter();
        JSONObject rspJson = new JSONObject();
        rspJson.put("code", (Object)"1");
        rspJson.put("message", (Object)error);
        String rspJsonStr = JSON.toJSONString((Object)rspJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(rspJsonStr);
        out.close();
    }

    public static void healthCheck(HttpServletResponse response) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter out = response.getWriter();
        JSONObject rspJson = new JSONObject();
        rspJson.put("status", (Object)"UP");
        rspJson.put("groups", (Object)new String[]{"liveness", "readiness"});
        String rspJsonStr = JSON.toJSONString((Object)rspJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(rspJsonStr);
        out.close();
    }
}

