/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.utils;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import com.tydic.nbchat.user.core.config.CaptchaConfigProperties;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KaptchaHelper {
    private static final Logger log = LoggerFactory.getLogger(KaptchaHelper.class);
    private final RedisHelper redisHelper;
    private final CaptchaConfigProperties captchaConfigProperties;

    public KaptchaHelper(RedisHelper redisHelper, CaptchaConfigProperties captchaConfigProperties) {
        this.redisHelper = redisHelper;
        this.captchaConfigProperties = captchaConfigProperties;
    }

    public boolean checkCaptchaCode(String code) {
        String key = "nbchat-user:captcha:" + code;
        boolean has = this.redisHelper.hasKey(key);
        if (has) {
            this.redisHelper.del(new String[]{key});
        }
        return has;
    }

    public AbstractCaptcha generateCaptchaCode() {
        int w = this.captchaConfigProperties.getWidth();
        int h = this.captchaConfigProperties.getHeight();
        int codeCount = this.captchaConfigProperties.getCodeCount();
        int lineCount = this.captchaConfigProperties.getLineCount();
        Object captcha = null;
        captcha = "circle".equals(this.captchaConfigProperties.getType()) ? CaptchaUtil.createCircleCaptcha((int)w, (int)h, (int)codeCount, (int)lineCount) : ("shear".equals(this.captchaConfigProperties.getType()) ? CaptchaUtil.createShearCaptcha((int)w, (int)h) : ("gif".equals(this.captchaConfigProperties.getType()) ? CaptchaUtil.createGifCaptcha((int)w, (int)h, (int)codeCount) : CaptchaUtil.createLineCaptcha((int)w, (int)h, (int)codeCount, (int)lineCount)));
        String key = "nbchat-user:captcha:" + captcha.getCode();
        this.redisHelper.set(key, (Object)captcha.getCode(), (long)this.captchaConfigProperties.getExpire());
        log.info("\u9a8c\u8bc1\u7801\u751f\u6210-\u5b8c\u6210:{}:{}", (Object)key, (Object)captcha.getCode());
        return captcha;
    }
}

