/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.utils;

import com.tydic.nbchat.user.api.NbChatSmsHelper;
import com.tydic.nbchat.user.api.bo.SendBatchSmsRequest;
import com.tydic.nbchat.user.api.bo.SendSmsRequest;
import com.tydic.nbchat.user.api.bo.eums.SmsHelperType;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NbchatSmsProxyHelper {
    private static final Logger log = LoggerFactory.getLogger(NbchatSmsProxyHelper.class);
    private final NbchatUserConfigProperties nbchatUserConfigProperties;
    private final List<NbChatSmsHelper> helperList;

    public NbchatSmsProxyHelper(NbchatUserConfigProperties nbchatUserConfigProperties, List<NbChatSmsHelper> helperList) {
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
        this.helperList = helperList;
    }

    public Rsp send(SmsHelperType type, SendSmsRequest request) {
        if (this.nbchatUserConfigProperties.getSms().isEnable()) {
            for (NbChatSmsHelper nbChatSmsHelper : this.helperList) {
                if (!nbChatSmsHelper.type().equals(type.getCode())) continue;
                return nbChatSmsHelper.sendSms(request);
            }
            throw new RuntimeException("\u627e\u4e0d\u5230\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\uff01");
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u672a\u5f00\u542f\u77ed\u4fe1\u670d\u52a1");
    }

    public RspList<String> sendBatch(SmsHelperType type, SendBatchSmsRequest request) {
        if (this.nbchatUserConfigProperties.getSms().isEnable()) {
            for (NbChatSmsHelper nbChatSmsHelper : this.helperList) {
                if (!nbChatSmsHelper.type().equals(type.getCode())) continue;
                return nbChatSmsHelper.sendBatchSms(request);
            }
            throw new RuntimeException("\u627e\u4e0d\u5230\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\uff01");
        }
        return BaseRspUtils.createErrorRspList((String)"0000", (String)"\u672a\u5f00\u542f\u77ed\u4fe1\u670d\u52a1");
    }
}

