/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.utils;

import com.tydic.nbchat.user.api.bo.SendSmsRequest;
import com.tydic.nbchat.user.mapper.PhoneCaptchaMapper;
import com.tydic.nbchat.user.mapper.po.PhoneCaptchaPO;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SmsRedisUtils {
    private static final Logger log = LoggerFactory.getLogger(SmsRedisUtils.class);
    private final RedisHelper redisHelper;
    private final PhoneCaptchaMapper phoneCaptchaMapper;

    public SmsRedisUtils(RedisHelper redisHelper, PhoneCaptchaMapper phoneCaptchaMapper) {
        this.redisHelper = redisHelper;
        this.phoneCaptchaMapper = phoneCaptchaMapper;
    }

    public void sendSms(SendSmsRequest sendSmsRequest) {
        String key = sendSmsRequest.getKey();
        String frequencyKey = sendSmsRequest.getFrequencyKey();
        String code = sendSmsRequest.getCode();
        String phone = sendSmsRequest.getPhone();
        String channel = sendSmsRequest.getChannel();
        String id = IdWorker.nextAutoIdStr();
        Date createdTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createdTime);
        calendar.add(12, 1);
        Date expiredTime = calendar.getTime();
        this.redisHelper.set(key, (Object)code, 60L);
        this.redisHelper.set(frequencyKey, (Object)5, 60L);
        PhoneCaptchaPO phoneCaptchaPO = new PhoneCaptchaPO();
        phoneCaptchaPO.setId(id);
        phoneCaptchaPO.setPhone(phone);
        phoneCaptchaPO.setCode(code);
        phoneCaptchaPO.setAppId(channel);
        phoneCaptchaPO.setCreatedTime(createdTime);
        phoneCaptchaPO.setExpiredTime(expiredTime);
        this.phoneCaptchaMapper.save(phoneCaptchaPO);
    }
}

