/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuyanSignatureUtils {
    private static final Logger log = LoggerFactory.getLogger(SuyanSignatureUtils.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final String ACCESS_KEY = "AccessKey";
    public static final String TIME_STAMP = "Timestamp";
    public static final String SIGNATURE = "Signature";
    public static final String SIGNATURE_METHOD = "SignatureMethod";
    public static final String SIGNATURE_VERSION = "SignatureVersion";
    public static final String SIGNATURE_NONCE = "SignatureNonce";
    public static final String SIGNATURE_VERSION_VALUE = "V2.0";
    public static final String SIGNATURE_METHOD_VALUE = "HmacSHA1";
    public static final String TIME_STAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String URL_ENCODER_FORMAT = "%s=%s";
    public static final String ENCODING = "utf-8";
    public static final String STRING_SEPARATOR = "\n";
    public static final String PARAMETER_SEPARATOR = "&";
    public static final String SIGNING_STRING = "BC_SIGNATURE&";
    public String accessKey;
    public String secretKey;

    public SuyanSignatureUtils(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public SuyanSignatureUtils() {
    }

    public String doSignature(String servletPath, String method, Map<String, Object> query) {
        try {
            servletPath = URLDecoder.decode(servletPath, ENCODING);
            query.put(ACCESS_KEY, this.accessKey);
            query.put(TIME_STAMP, this.sdf.format(new Date()));
            query.put(SIGNATURE_NONCE, UUID.randomUUID().toString().replace("-", ""));
            query.put(SIGNATURE_VERSION, SIGNATURE_VERSION_VALUE);
            query.put(SIGNATURE_METHOD, SIGNATURE_METHOD_VALUE);
            ArrayList<String> parameterList = new ArrayList<String>(query.keySet());
            Collections.sort(parameterList);
            ArrayList<String> list = new ArrayList<String>(query.size());
            for (String name : parameterList) {
                if (SIGNATURE.equalsIgnoreCase(name)) continue;
                String value = query.get(name) instanceof Boolean ? (Boolean.getBoolean(name) ? "true" : "false") : query.get(name).toString();
                list.add(String.format(URL_ENCODER_FORMAT, SuyanSignatureUtils.percentEncode(name), SuyanSignatureUtils.percentEncode(value)));
            }
            String canonicalizedQueryString = String.join((CharSequence)PARAMETER_SEPARATOR, list);
            String encryptedCanonicalizedQueryStr = SuyanSignatureUtils.encode(canonicalizedQueryString);
            StringBuilder sb = new StringBuilder();
            sb.append(method.toUpperCase());
            sb.append(STRING_SEPARATOR);
            sb.append(SuyanSignatureUtils.percentEncode(servletPath));
            sb.append(STRING_SEPARATOR);
            sb.append(encryptedCanonicalizedQueryStr);
            String signature = SuyanSignatureUtils.sign(SIGNING_STRING + this.secretKey, sb.toString());
            if (Objects.isNull(signature) || signature.length() == 0) {
                return null;
            }
            return servletPath + "?" + canonicalizedQueryString + PARAMETER_SEPARATOR + String.format(URL_ENCODER_FORMAT, SIGNATURE, SuyanSignatureUtils.percentEncode(signature));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static String sign(String secretKey, String data) {
        try {
            Mac mac = Mac.getInstance(SIGNATURE_METHOD_VALUE);
            byte[] secretKeyByte = secretKey.getBytes(ENCODING);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKeyByte, SIGNATURE_METHOD_VALUE);
            mac.init(secretKeySpec);
            return new String(SuyanSignatureUtils.encodeHex(mac.doFinal(data.getBytes(ENCODING))));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String encode(String data) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(data.getBytes(ENCODING));
        return new String(SuyanSignatureUtils.encodeHex(hash));
    }

    protected static char[] encodeHex(byte[] data) {
        char[] toDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }
}

