/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.utils;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.SysPlatformDefine;
import com.tydic.nbchat.user.api.bo.mq.UserRegistContext;
import com.tydic.nbchat.user.api.bo.vip.UserVipBO;
import com.tydic.nbchat.user.core.busi.UserGrayExpressService;
import com.tydic.nbchat.user.core.busi.UserVipTrialBusiService;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.mapper.UserSettingsMapper;
import com.tydic.nbchat.user.mapper.po.UserSettings;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserSettingHelper {
    private static final Logger log = LoggerFactory.getLogger(UserSettingHelper.class);
    private final RedisHelper redisHelper;
    private final KKMqProducerHelper kkMqProducerHelper;
    private final UserVipTrialBusiService userVipTrialBusiService;
    private final UserGrayExpressService userGrayExpressService;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;
    private static final String NEW_REG = "nbchat-user:new-reg:";
    @Resource
    private UserSettingsMapper userSettingsMapper;

    public UserSettingHelper(RedisHelper redisHelper, KKMqProducerHelper kkMqProducerHelper, UserVipTrialBusiService userVipTrialBusiService, UserGrayExpressService userGrayExpressService, NbchatUserConfigProperties nbchatUserConfigProperties) {
        this.redisHelper = redisHelper;
        this.kkMqProducerHelper = kkMqProducerHelper;
        this.userVipTrialBusiService = userVipTrialBusiService;
        this.userGrayExpressService = userGrayExpressService;
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
    }

    public void userRegistNotice(UserRegistContext registContext) {
        this.kkMqProducerHelper.sendMsg("NBCHAT_USER_REGIST", (Object)registContext);
        this.redisHelper.set(NEW_REG + registContext.getUserId(), (Object)registContext, 86400L);
        try {
            this.userVipTrialBusiService.addByConf(registContext.getPromChannel(), registContext.getUserId());
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u8bd5\u7528\u7528\u6237-\u5f02\u5e38: {}, promChannel: {}", new Object[]{registContext.getUserId(), registContext.getPromChannel(), e});
        }
        try {
            this.userGrayExpressService.addGrayUserByExpress(registContext);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u7070\u5ea6\u7528\u6237-\u5f02\u5e38: {}", (Object)registContext, (Object)e);
        }
    }

    public void cleanUserCache(String tenantCode, String userId) {
        this.removeInfo(userId);
        this.removeBaseInfo(tenantCode, userId);
        this.removeVipInfo(tenantCode, userId);
        if (!"00000000".equals(tenantCode)) {
            this.removeVipInfo("00000000", userId);
        }
    }

    public void cleanUserCache(String tenantCode, String userId, String platform) {
        this.removeInfo(userId);
        this.removeBaseInfo(tenantCode, userId);
        this.removeVipInfo(tenantCode, userId);
        if (!"00000000".equals(tenantCode)) {
            this.removeVipInfo("00000000", userId);
        }
        this.removePlatform(userId, platform);
    }

    public NbchatUserInfo getUserInfo(String userId) {
        String key = "nbchat-user:info:" + userId;
        return (NbchatUserInfo)this.redisHelper.get(key);
    }

    public boolean hasInfo(String userId) {
        String key = "nbchat-user:info:" + userId;
        return this.redisHelper.hasKey(key);
    }

    public void removeInfo(String userId) {
        String key = "nbchat-user:info:" + userId;
        this.redisHelper.del(new String[]{key});
    }

    public void removePlatform(String userId) {
        for (SysPlatformDefine value : SysPlatformDefine.values()) {
            this.redisHelper.hdel("nbchat-user:settings:" + userId, new Object[]{value.getCode()});
        }
    }

    public void removePlatform(String userId, String platform) {
        if (StringUtils.isBlank((CharSequence)platform)) {
            return;
        }
        this.redisHelper.hdel("nbchat-user:settings:" + userId, new Object[]{platform});
    }

    public void removeBaseInfo(String tenantCode, String userId) {
        String key = "nbchat-user:info:" + tenantCode + ":" + userId;
        this.redisHelper.del(new String[]{key});
    }

    public void removeSetting(String userId) {
        String key = "nbchat-user:settings:" + userId;
        this.redisHelper.del(new String[]{key});
    }

    public void cacheInfo(NbchatUserInfo userInfo) {
        String key = "nbchat-user:info:" + userInfo.getUserId();
        this.redisHelper.set(key, (Object)userInfo, TimeUnit.HOURS.toSeconds(2L));
    }

    public UserVipBO getVipInfo(String tenantCode, String userId) {
        String key = "nbchat-user:vip:" + tenantCode + ":" + userId;
        return (UserVipBO)this.redisHelper.get(key);
    }

    public void cacheVipInfo(String tenantCode, String userId, UserVipBO vipInfo) {
        String key = "nbchat-user:vip:" + tenantCode + ":" + userId;
        this.redisHelper.set(key, (Object)vipInfo, TimeUnit.HOURS.toSeconds(2L));
    }

    public void removeVipInfo(String tenantCode, String userId) {
        String key = "nbchat-user:vip:" + tenantCode + ":" + userId;
        this.redisHelper.del(new String[]{key});
    }

    public String createBindCode(int expTime) {
        Integer code = NiccCommonUtil.generateRandomCode((int)1000000, (int)9999999);
        String key = "nbchat-user:settings:bindcode:" + code;
        this.redisHelper.set(key, (Object)EntityValidType.NORMAL.getCode(), (long)expTime);
        return String.valueOf(code);
    }

    public boolean checkBindCode(String code) {
        String key = "nbchat-user:settings:bindcode:" + code;
        return this.redisHelper.hasKey(key);
    }

    public Map<Object, Object> loadSetting(String userId) {
        String cacheKey = "nbchat-user:settings:" + userId;
        Map<Object, Object> map = this.redisHelper.hmget(cacheKey);
        if (map == null || map.isEmpty()) {
            UserSettings setting = this.userSettingsMapper.selectByUserId(userId);
            if (setting != null && StringUtils.isNotBlank((CharSequence)setting.getCurrentSetting())) {
                try {
                    map = (Map)JSONObject.parseObject((String)setting.getCurrentSetting(), Map.class);
                    this.updateSetting(userId, map);
                    return map;
                }
                catch (Exception e) {
                    log.error("\u7528\u6237\u8bbe\u7f6e\u4fe1\u606f\u89e3\u6790\u5f02\u5e38:{}", (Object)setting, (Object)e);
                }
            }
            map = new HashMap<Object, Object>();
        }
        for (Map.Entry<String, Object> entry : this.nbchatUserConfigProperties.getDefaultUserSettings().entrySet()) {
            map.computeIfAbsent(entry.getKey(), k -> entry.getValue());
        }
        return map;
    }

    public int updateSetting(String userId, Map<Object, Object> configMap) {
        int i = 0;
        String cacheKey = "nbchat-user:settings:" + userId;
        for (Map.Entry<Object, Object> entry : configMap.entrySet()) {
            String item = entry.getKey().toString();
            Object val = entry.getValue();
            if (val == null) {
                this.redisHelper.hdel(cacheKey, new Object[]{item});
            } else {
                this.redisHelper.hset(cacheKey, item, val);
            }
            ++i;
            this.removeInfo(userId);
        }
        return i;
    }
}

