/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.tydic.nbchat.user.api.UserAccountApi;
import com.tydic.nbchat.user.api.bo.ChangePhoneNumberReqBO;
import com.tydic.nbchat.user.api.bo.account.UserAccountUpdateReqBO;
import com.tydic.nbchat.user.api.bo.account.UserLockAccountReqBO;
import com.tydic.nbchat.user.api.bo.account.UserUnLockAccountReqBO;
import com.tydic.nbchat.user.api.bo.account.UserUnRegAccountReqBO;
import com.tydic.nbchat.user.core.busi.UserAccountUnRegBusiService;
import com.tydic.nbchat.user.core.busi.UserAuthBusiService;
import com.tydic.nbchat.user.core.busi.UserLoginLockBusiService;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user/"})
public class UserAccountController {
    private static final Logger log = LoggerFactory.getLogger(UserAccountController.class);
    private final UserAuthBusiService userAuthBusiService;
    private final UserAccountUnRegBusiService userAccountUnRegBusiService;
    private final UserAccountApi userAccountApi;
    private final UserLoginLockBusiService userLoginLockBusiService;

    public UserAccountController(UserAuthBusiService userAuthBusiService, UserAccountUnRegBusiService userAccountUnRegBusiService, UserAccountApi userAccountApi, UserLoginLockBusiService userLoginLockBusiService) {
        this.userAuthBusiService = userAuthBusiService;
        this.userAccountUnRegBusiService = userAccountUnRegBusiService;
        this.userAccountApi = userAccountApi;
        this.userLoginLockBusiService = userLoginLockBusiService;
    }

    @RequiresRole(value={"sysAdmin"})
    @PostMapping(value={"/account/lock"})
    public Rsp lock(@Validated @RequestBody UserLockAccountReqBO request) {
        log.info("\u9501\u5b9a\u7528\u6237\u8d26\u6237: {}", (Object)request);
        Long lockTime = null;
        if (request.getLockTime() != null) {
            lockTime = (System.currentTimeMillis() - request.getLockTime().getTime()) / 1000L;
        }
        this.userLoginLockBusiService.lockAccount(request.getUsername(), lockTime, request.getReason());
        return BaseRspUtils.createSuccessRsp((Object)request.getUsername(), (String)"\u8d26\u6237\u9501\u5b9a\u6210\u529f");
    }

    @RequiresRole(value={"sysAdmin"})
    @PostMapping(value={"/account/unlock"})
    public Rsp unlock(@Validated @RequestBody UserUnLockAccountReqBO request) {
        log.info("\u89e3\u9501\u7528\u6237\u8d26\u6237: {}", (Object)request);
        this.userLoginLockBusiService.unlockAccount(request.getUsername());
        return BaseRspUtils.createSuccessRsp((Object)request.getUsername(), (String)"\u8d26\u6237\u89e3\u9501\u6210\u529f");
    }

    @PostMapping(value={"/account/remove"})
    public Rsp unRegUser(@Validated @RequestBody UserUnRegAccountReqBO request) {
        return this.userAccountUnRegBusiService.unRegUser(request);
    }

    @PostMapping(value={"/account/change/phone"})
    public Rsp changePhone(@RequestBody ChangePhoneNumberReqBO request) {
        return this.userAuthBusiService.changePhone(request);
    }

    @PostMapping(value={"/account/update"})
    public Rsp update(@RequestBody UserAccountUpdateReqBO request) {
        return this.userAccountApi.updateAccount(request);
    }
}

