/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.BindPhoneNumberReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.UserSwitchTenantRequest;
import com.tydic.nbchat.user.api.bo.auth.UserTokenInfo;
import com.tydic.nbchat.user.api.bo.auth.UserWxReqeust;
import com.tydic.nbchat.user.api.bo.vip.SuYanAuthCodeReqBO;
import com.tydic.nbchat.user.core.busi.UserAuthBusiService;
import com.tydic.nbchat.user.core.busi.UserGrayService;
import com.tydic.nbchat.user.core.busi.UserLoginLockBusiService;
import com.tydic.nbchat.user.core.busi.UserTenantSwitchService;
import com.tydic.nbchat.user.core.busi.WchatApiHelper;
import com.tydic.nbchat.user.core.utils.IPUtils;
import com.tydic.nicc.common.bo.BaseInfo;
import com.tydic.nicc.common.nbchat.emus.UserOperationType;
import com.tydic.nicc.common.nbchat.msg.UserOperateLogContext;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.JWTUtils;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user/"})
public class UserAuthController {
    private static final Logger log = LoggerFactory.getLogger(UserAuthController.class);
    private final UserAuthBusiService userAuthBusiService;
    private final UserLoginLockBusiService userLoginLockBusiService;
    private final UserTenantSwitchService userTenantSwitchService;
    private final UserGrayService userGrayService;
    private final KKMqProducerHelper kkMqProducerHelper;
    private final RedisHelper redisHelper;
    private final NbchatUserApi nbchatUserApi;
    private final WchatApiHelper wchatApiHelper;

    public UserAuthController(UserAuthBusiService userAuthBusiService, UserLoginLockBusiService userLoginLockBusiService, UserTenantSwitchService userTenantSwitchService, UserGrayService userGrayService, RedisHelper redisHelper, NbchatUserApi nbchatUserApi, WchatApiHelper wchatApiHelper, KKMqProducerHelper kkMqProducerHelper) {
        this.userAuthBusiService = userAuthBusiService;
        this.userLoginLockBusiService = userLoginLockBusiService;
        this.userTenantSwitchService = userTenantSwitchService;
        this.userGrayService = userGrayService;
        this.redisHelper = redisHelper;
        this.nbchatUserApi = nbchatUserApi;
        this.wchatApiHelper = wchatApiHelper;
        this.kkMqProducerHelper = kkMqProducerHelper;
    }

    @GetMapping(value={"/auth/unlock/0h8Mn9RPMiy7KMHD5vEc/{username}"})
    public Rsp unlockAccount(@PathVariable(value="username") String username, HttpServletResponse response) {
        this.userLoginLockBusiService.unlockAccount(username);
        return BaseRspUtils.createSuccessRsp((Object)username, (String)"unlock success");
    }

    @GetMapping(value={"/auth/0h8Mn9RPMiy7KMHD5vEc/{uid}"})
    public Rsp authUser(@PathVariable(value="uid") String uid, HttpServletResponse response) {
        try {
            log.info("\u7528\u6237\u767b\u5f55\u8ba4\u8bc1: uid = {}", (Object)uid);
            NbchatUserInfo userInfo = this.userAuthBusiService.getUserInfo(uid);
            if (userInfo != null) {
                String loginInfo = UserTokenInfo.of((String)userInfo.getUserId(), (String)userInfo.getTenantCode());
                int expTime = 43200;
                String token = JWTUtils.createJwtToken((String)userInfo.getUserId(), (String)loginInfo, (Long)((long)expTime * 1000L));
                Cookie cookie = new Cookie(UserAuthBusiService.HEADER_TOKEN_KEY, token);
                cookie.setPath("/");
                cookie.setMaxAge(expTime);
                response.addCookie(cookie);
                try {
                    String cacheKey = "nbchat-user:session:" + userInfo.getUserId();
                    this.redisHelper.set(cacheKey, (Object)MD5Utils.md5Hex((byte[])token.getBytes()), (long)expTime);
                }
                catch (NoSuchAlgorithmException e) {
                    log.warn("token \u8ba1\u7b97md5\u5f02\u5e38:", (Throwable)e);
                }
                return BaseRspUtils.createSuccessRsp((Object)token);
            }
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u5f02\u5e38!");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u767b\u5f55\u8ba4\u8bc1-\u89e3\u6790\u5f02\u5e38: uid = {}", (Object)uid, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u8ba4\u8bc1\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/auth/login"})
    public Rsp login(@RequestBody AuthUserReqBO authUserReqBO, HttpServletRequest request, HttpServletResponse response) {
        authUserReqBO.setLoginUa(request.getHeader("User-Agent"));
        authUserReqBO.setLoginIp(IPUtils.getIpAddr(request));
        return this.userAuthBusiService.login(authUserReqBO, request, response);
    }

    @GetMapping(value={"/auth/logout"})
    public Rsp logout(HttpServletRequest request, HttpServletResponse response) {
        String token = this.userAuthBusiService.getAuthToken(request);
        try {
            if (StringUtils.isNotBlank((CharSequence)token)) {
                String loginInfo = JWTUtils.getLoginInfo((String)token);
                log.info("\u7528\u6237\u9000\u51fa\u767b\u5f55-\u5f00\u59cb:{}", (Object)loginInfo);
                UserTokenInfo userInfo = UserTokenInfo.parse((String)loginInfo);
                userInfo.setPlatform(request.getHeader("platform"));
                this.userAuthBusiService.authLogout(userInfo, token);
                UserOperateLogContext userOperateLogContext = UserOperateLogContext.build((UserOperationType)UserOperationType.LOGOUT, (String)userInfo.getTenantCode(), (String)userInfo.getUserId(), (UserOperateLogContext.BuildParams)UserOperateLogContext.BuildParams.builder().clientUa(request.getHeader("User-Agent")).clientIp(IPUtils.getIpAddr(request)).build());
                try {
                    log.info("\u53d1\u9001\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\u4e8b\u4ef6\u6d88\u606f: {}", (Object)userOperateLogContext);
                    this.kkMqProducerHelper.sendMsg("NBCHAT_USER_OPERATE_LOG", (Object)userOperateLogContext);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\u4e8b\u4ef6\u6d88\u606f-\u5f02\u5e38:{}", (Object)userOperateLogContext, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u4fe1\u606f\u89e3\u6790\u5f02\u5e38:", (Throwable)e);
        }
        Cookie cookie = new Cookie(UserAuthBusiService.HEADER_TOKEN_KEY, "");
        cookie.setPath("/");
        response.addCookie(cookie);
        return BaseRspUtils.createSuccessRsp((Object)"logout success");
    }

    @GetMapping(value={"/auth/yuewen/login_check"})
    public Rsp yuewenLoginCheck(@RequestParam(value="data") String data, HttpServletResponse response) {
        return this.userAuthBusiService.yuwenLoginCheck(data, response);
    }

    @GetMapping(value={"/auth/login_check"})
    public Rsp loginCheck(@RequestParam(value="sessionKey") String sessionKey, HttpServletResponse response) {
        NbchatUserInfo userInfo = this.userAuthBusiService.loginCheck(sessionKey, response);
        if (userInfo == null) {
            return BaseRspUtils.createSuccessRsp(null, (String)"\u7b49\u5f85\u626b\u7801");
        }
        return BaseRspUtils.createSuccessRsp((Object)userInfo);
    }

    @PostMapping(value={"/bind/phone"})
    public Rsp bindPhone(@RequestBody BindPhoneNumberReqBO bindPhoneNumber, HttpServletRequest request, HttpServletResponse response) {
        bindPhoneNumber.setClientUa(request.getHeader("User-Agent"));
        bindPhoneNumber.setClientIp(IPUtils.getIpAddr(request));
        return this.userAuthBusiService.bindPhone(bindPhoneNumber, request, response);
    }

    @PostMapping(value={"mp/bindPhone"})
    public Rsp bindPhoneByMP(@RequestBody BindPhoneNumberReqBO reqBO, HttpServletRequest request, HttpServletResponse response) {
        reqBO.setClientUa(request.getHeader("User-Agent"));
        reqBO.setClientIp(IPUtils.getIpAddr(request));
        return this.nbchatUserApi.bindPhoneByMPCode(reqBO);
    }

    @PostMapping(value={"/wx/info"})
    public Rsp login(@Validated @RequestBody UserWxReqeust request) {
        try {
            return BaseRspUtils.createSuccessRsp((Object)this.wchatApiHelper.getWxInfo(request));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u4fe1\u606f-\u5931\u8d25: request = {}", (Object)request, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/info"})
    public Rsp getInfo(@RequestBody BaseInfo baseInfo, HttpServletRequest request, HttpServletResponse response) {
        try {
            String platform = request.getHeader("platform");
            NbchatUserInfo userInfo = null;
            if (StringUtils.isNotBlank((CharSequence)baseInfo.get_userId())) {
                userInfo = this.userAuthBusiService.getUserInfo(baseInfo.get_userId(), platform);
                if (userInfo.getTenantCodeList() == null) {
                    userInfo.setTenantCodeList(Collections.singletonList(userInfo.getTenantCode()));
                }
            } else {
                String token = this.userAuthBusiService.getAuthToken(request);
                String loginInfo = JWTUtils.getLoginInfo((String)token);
                UserTokenInfo tokenInfo = UserTokenInfo.parse((String)loginInfo);
                if (tokenInfo == null) {
                    Rsp rsp = BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
                    return rsp;
                }
                userInfo = this.userAuthBusiService.getUserInfo(tokenInfo.getUserId(), platform);
                if (userInfo.getTenantCodeList() == null) {
                    userInfo.setTenantCodeList(Collections.singletonList(userInfo.getTenantCode()));
                }
            }
            Map<String, Object> grayMap = this.userGrayService.getGrayMap(userInfo.getTenantCode(), userInfo.getUserId());
            userInfo.setGrayFeatures(grayMap);
            Rsp rsp = BaseRspUtils.createSuccessRsp((Object)userInfo);
            return rsp;
        }
        catch (JWTVerificationException e) {
            response.setStatus(401);
            log.warn("\u7528\u6237\u4fe1\u606f\u67e5\u8be2-token\u89e3\u6790\u5f02\u5e38:", (Throwable)e);
        }
        catch (Exception e1) {
            log.error("\u7528\u6237\u4fe1\u606f\u67e5\u8be2-\u5f02\u5e38:", (Throwable)e1);
        }
        finally {
            boolean refresh = this.userAuthBusiService.refreshToken(request, response);
            if (refresh) {
                log.warn("\u7528\u6237\u4fe1\u606f\u67e5\u8be2-token\u7eed\u671f: {}", (Object)baseInfo.get_userId());
            }
        }
        return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
    }

    @PostMapping(value={"/auth/switch/tenant"})
    public Rsp switchTenant(HttpServletRequest request, @Validated @RequestBody UserSwitchTenantRequest param) {
        param.setLoginUa(request.getHeader("User-Agent"));
        param.setLoginIp(IPUtils.getIpAddr(request));
        return this.userTenantSwitchService.switchPlatformTenant(param);
    }

    @PostMapping(value={"/auth/suyan/login_check"})
    public Rsp suyanLoginCheck(@RequestBody SuYanAuthCodeReqBO authUserReqBO, HttpServletRequest request, HttpServletResponse response) {
        authUserReqBO.setClientUa(request.getHeader("User-Agent"));
        authUserReqBO.setClientIp(IPUtils.getIpAddr(request));
        authUserReqBO.setRequestId(request.getHeader("csa-request-id"));
        return this.userAuthBusiService.suyanLoginCheck(authUserReqBO, response);
    }
}

