/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.tydic.nbchat.user.api.NbchatUserRegLoginApi;
import com.tydic.nbchat.user.api.UserBaseInfoApi;
import com.tydic.nbchat.user.api.UserService;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.UserBO;
import com.tydic.nbchat.user.api.bo.UserQueryReqBO;
import com.tydic.nbchat.user.api.bo.regist.UserRegistReqBO;
import com.tydic.nbchat.user.core.busi.UserLoginEventService;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.core.utils.IPUtils;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    private final UserService userService;
    private final NbchatUserRegLoginApi nbchatUserRegLoginApi;
    private final UserLoginEventService userLoginEventService;
    private final UserBaseInfoApi userBaseInfoApi;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;

    public UserController(UserService userService, NbchatUserRegLoginApi nbchatUserRegLoginApi, UserLoginEventService userLoginEventService, UserBaseInfoApi userBaseInfoApi, NbchatUserConfigProperties nbchatUserConfigProperties) {
        this.userService = userService;
        this.nbchatUserRegLoginApi = nbchatUserRegLoginApi;
        this.userLoginEventService = userLoginEventService;
        this.userBaseInfoApi = userBaseInfoApi;
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
    }

    @PostMapping(value={"/regist"})
    public Rsp regist(HttpServletRequest request, @RequestBody UserRegistReqBO registReqBO) {
        registReqBO.setClientUa(request.getHeader("User-Agent"));
        registReqBO.setClientIp(IPUtils.getIpAddr(request));
        if (!this.nbchatUserConfigProperties.getUserRegEnable().booleanValue()) {
            log.warn("\u7528\u6237\u6ce8\u518c-\u672a\u5f00\u653e\u7528\u6237\u6ce8\u518c: {}", (Object)registReqBO);
            return BaseRspUtils.createErrorRsp((String)"\u672a\u5f00\u653e\u7528\u6237\u6ce8\u518c");
        }
        return this.nbchatUserRegLoginApi.regist(registReqBO);
    }

    @PostMapping(value={"/base/info"})
    public Rsp baseInfo(@RequestBody UserQueryReqBO queryReqBO) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{queryReqBO.getUid(), queryReqBO.getPhone()})) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqBO.getUid())) {
            return this.userBaseInfoApi.getByUserId(queryReqBO.getTenantCode(), queryReqBO.getUid());
        }
        return this.userBaseInfoApi.getByPhone(queryReqBO.getTenantCode(), queryReqBO.getPhone());
    }

    @PostMapping(value={"/sms/send"})
    public Rsp sendSMS(@RequestBody AuthUserReqBO authUserReqBO) {
        return this.userService.sendSMS(authUserReqBO);
    }

    @PostMapping(value={"/sms/sendApplyRes"})
    public Rsp sendSMSApply(@RequestBody AuthUserReqBO authUserReqBO) {
        return this.userService.sendSMSApply(authUserReqBO);
    }

    @PostMapping(value={"/phone/{phone}"})
    public Rsp getUserByPhone(@PathVariable(value="phone") String phone) {
        Rsp rsp = this.userService.getUserByPhone(phone);
        return rsp;
    }

    @PostMapping(value={"/list"})
    public RspList list(@RequestBody UserQueryReqBO queryReqBO) {
        return this.userService.queryPage(queryReqBO);
    }

    @PostMapping(value={"/update"})
    public Rsp update(HttpServletRequest request, @RequestBody UserBO userBO) {
        userBO.setLoginUa(request.getHeader("User-Agent"));
        userBO.setLoginIp(IPUtils.getIpAddr(request));
        Rsp update = this.userService.updateById(userBO);
        if (update.isSuccess() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userBO.getTenantCode(), userBO.getTargetTenant()})) {
            this.userLoginEventService.sengLoginSwitchTenant(userBO.getUserId(), "", userBO.getLoginIp(), userBO.getLoginUa(), userBO.getTargetTenant());
        }
        return update;
    }
}

