/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.UserManageService;
import com.tydic.nbchat.user.api.bo.manage.ImportUserRequest;
import com.tydic.nbchat.user.api.bo.manage.UpdateUserRequest;
import com.tydic.nbchat.user.core.utils.IPUtils;
import com.tydic.nbchat.user.core.utils.excel.UserInfoExcel;
import com.tydic.nbchat.user.core.utils.excel.listener.ImportUserInfoListener;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/user/manage"})
public class UserManageController {
    private static final Logger log = LoggerFactory.getLogger(UserManageController.class);
    private final NbchatUserApi nbchatUserApi;
    private final UserManageService userManageService;

    public UserManageController(NbchatUserApi nbchatUserApi, UserManageService userManageService) {
        this.nbchatUserApi = nbchatUserApi;
        this.userManageService = userManageService;
    }

    @PostMapping(value={"/import"})
    public Rsp importUser(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        String tenant = request.getParameter("tenant");
        String userId = request.getParameter("userId");
        String password = request.getParameter("password");
        if (StringUtils.isBlank((CharSequence)tenant)) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8bbe\u7f6e\u79df\u6237\u7f16\u7801\uff01");
        }
        if (file == null) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u6587\u4ef6\uff01");
        }
        ImportUserInfoListener listener = new ImportUserInfoListener();
        try {
            EasyExcel.read((InputStream)file.getInputStream(), UserInfoExcel.class, (ReadListener)listener).sheet().doRead();
            ImportUserRequest importUserRequest = new ImportUserRequest();
            importUserRequest.setUserId(userId);
            importUserRequest.setPassword(password);
            importUserRequest.setTenant(tenant);
            importUserRequest.setUsers(listener.getRecord());
            importUserRequest.setClientUa(request.getHeader("User-Agent"));
            importUserRequest.setClientIp(IPUtils.getIpAddr(request));
            return this.userManageService.importUsers(importUserRequest);
        }
        catch (Exception e) {
            return BaseRspUtils.createErrorRsp((String)("\u7528\u6237\u5bfc\u5165\u5f02\u5e38:\u8bf7\u68c0\u67e5\u6570\u636e,\u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public Rsp updateInfo(@RequestBody UpdateUserRequest request) {
        return this.userManageService.updateInfo(request);
    }
}

