/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.tydic.nbchat.user.api.UserSettingsApi;
import com.tydic.nbchat.user.api.bo.setting.CheckSettingBindCodeReqBO;
import com.tydic.nbchat.user.api.bo.setting.CreateSettingBindCodeReqBO;
import com.tydic.nbchat.user.api.bo.setting.UserSettingFlashReqBO;
import com.tydic.nbchat.user.api.bo.setting.UserSettingReqBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class UserSettingsController {
    private static final Logger log = LoggerFactory.getLogger(UserSettingsController.class);
    private final UserSettingsApi userSettingsApi;

    public UserSettingsController(UserSettingsApi userSettingsApi) {
        this.userSettingsApi = userSettingsApi;
    }

    @GetMapping(value={"/settings/batch/update/{currentRobotType}/{setRobotType}"})
    public Rsp updateDefaultRobot(@PathVariable(value="currentRobotType") String currentRobotType, @PathVariable(value="setRobotType") String setRobotType) {
        return this.userSettingsApi.updateDefaultRobot(currentRobotType, setRobotType);
    }

    @PostMapping(value={"/settings/bindcode/check"})
    public Rsp checkSettingBindCode(@RequestBody CheckSettingBindCodeReqBO reqBO) {
        try {
            return this.userSettingsApi.checkSettingBindCode(reqBO);
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u7ed1\u5b9a\u7801\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u6821\u9a8c\u7ed1\u5b9a\u7801\u5f02\u5e38!");
        }
    }

    @PostMapping(value={"/settings/bindcode/generate"})
    public Rsp createSettingBindCode(@RequestBody CreateSettingBindCodeReqBO reqBO) {
        try {
            return this.userSettingsApi.createSettingBindCode(reqBO);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7ed1\u5b9a\u7801\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u521b\u5efa\u7ed1\u5b9a\u7801\u5f02\u5e38!");
        }
    }

    @PostMapping(value={"/settings/save"})
    public Rsp saveSettings(@RequestBody UserSettingReqBO reqBO) {
        try {
            return this.userSettingsApi.saveSettings(reqBO);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u8bbe\u7f6e\u4fdd\u5b58\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u8bbe\u7f6e\u4fdd\u5b58\u5f02\u5e38!");
        }
    }

    @PostMapping(value={"/settings/flash"})
    public Rsp flashSettings(@RequestBody UserSettingFlashReqBO reqBO) {
        return this.userSettingsApi.flashSettings(reqBO);
    }

    @PostMapping(value={"/settings"})
    public Rsp loadSettings(@RequestBody UserSettingReqBO reqBO) {
        return this.userSettingsApi.loadSettings(reqBO.getUserId());
    }
}

