/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.tydic.nbchat.user.api.UserSuggestionService;
import com.tydic.nbchat.user.api.UserVideoIssuesApi;
import com.tydic.nbchat.user.api.bo.suggestion.SuggestionSaveReqBO;
import com.tydic.nbchat.user.api.bo.suggestion.UserSuggestionRspBO;
import com.tydic.nbchat.user.api.bo.suggestion.UserVideoIssuesBO;
import com.tydic.nbchat.user.api.bo.suggestion.UserVideoIssuesReqBo;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class UserSuggestController {
    private static final Logger log = LoggerFactory.getLogger(UserSuggestController.class);
    private final UserSuggestionService userSuggestionService;
    private final UserVideoIssuesApi userVideoIssuesApi;

    public UserSuggestController(UserSuggestionService userSuggestionService, UserVideoIssuesApi userVideoIssuesApi) {
        this.userSuggestionService = userSuggestionService;
        this.userVideoIssuesApi = userVideoIssuesApi;
    }

    @PostMapping(value={"/suggest/save"})
    public Rsp saveSuggestion(@RequestBody SuggestionSaveReqBO reqBO) {
        return this.userSuggestionService.saveSuggestion(reqBO);
    }

    @RequiresRole(value={"sysAdmin"})
    @PostMapping(value={"/suggest/admin_list"})
    public RspList<UserVideoIssuesBO> getVideoIssuesList(@RequestBody UserVideoIssuesReqBo queryReqBO) {
        return this.userVideoIssuesApi.getVideoIssuesList(queryReqBO);
    }

    @RequiresRole(value={"sysAdmin"})
    @PostMapping(value={"/suggest/suggestion_list"})
    public RspList<UserVideoIssuesBO> getSuggestionList(@RequestBody UserVideoIssuesReqBo queryReqBO) {
        return this.userVideoIssuesApi.getSuggestionList(queryReqBO);
    }

    @PostMapping(value={"/suggest/video_cost"})
    public RspList<UserVideoIssuesBO> selectVideoCostByBizId(@RequestBody UserVideoIssuesReqBo queryReqBO) {
        return this.userVideoIssuesApi.selectVideoCostByBizId(queryReqBO);
    }

    @RequiresRole(value={"sysAdmin"})
    @PostMapping(value={"/suggest/video_refund"})
    public Rsp adminAuditVideoIssues(@RequestBody UserVideoIssuesReqBo reqBO) {
        return this.userVideoIssuesApi.adminAuditVideoIssues(reqBO);
    }

    @PostMapping(value={"/suggest/video_issues"})
    public Rsp<?> getSuggestionByBusiId(@RequestBody UserVideoIssuesReqBo reqBO) {
        return this.userSuggestionService.getSuggestionByBusiId(reqBO);
    }

    @RequiresRole(value={"sysAdmin"})
    @PostMapping(value={"/suggest/video_give"})
    public Rsp adminGiveVideoIssues(@RequestBody UserVideoIssuesReqBo reqBO) {
        return this.userVideoIssuesApi.adminGiveVideoIssues(reqBO);
    }

    @PostMapping(value={"/suggest/stats"})
    public Rsp<UserSuggestionRspBO> selectSuggestionStats(@RequestBody UserVideoIssuesReqBo reqBO) {
        return this.userVideoIssuesApi.selectSuggestionStats(reqBO);
    }
}

