/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.tydic.nbchat.user.api.bo.trade.UserBalanceAccountReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceDeductReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceQueryReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRechargeReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRefundReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBillRecordBO;
import com.tydic.nbchat.user.api.bo.trade.UserBillRecordQueryReqBO;
import com.tydic.nbchat.user.api.trade.TradeBalanceApi;
import com.tydic.nbchat.user.api.trade.TradeBillRecordApi;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user/trade"})
public class UserTradeController {
    private static final Logger log = LoggerFactory.getLogger(UserTradeController.class);
    private final TradeBalanceApi tradeBalanceApi;
    private final TradeBillRecordApi tradeBillRecordApi;

    public UserTradeController(TradeBalanceApi tradeBalanceApi, TradeBillRecordApi tradeBillRecordApi) {
        this.tradeBalanceApi = tradeBalanceApi;
        this.tradeBillRecordApi = tradeBillRecordApi;
    }

    @PostMapping(value={"/account/create"})
    public Rsp createBalanceAccount(@RequestBody UserBalanceAccountReqBO accountReqBO) {
        return this.tradeBalanceApi.createBalanceAccount(accountReqBO);
    }

    @PostMapping(value={"/balance/info"})
    public Rsp balance(@RequestBody UserBalanceQueryReqBO baseInfo) {
        return this.tradeBalanceApi.getBalance(baseInfo.getTenantCode(), baseInfo.getUserId());
    }

    @PostMapping(value={"/balance/check"})
    public Rsp check(@RequestBody UserBalanceRechargeReqBO checkReqBO) {
        return this.tradeBalanceApi.deductCheck(checkReqBO);
    }

    @PostMapping(value={"/balance/recharge"})
    public Rsp recharge(@RequestBody UserBalanceRechargeReqBO rechargeReqBO) {
        return this.tradeBalanceApi.recharge(rechargeReqBO);
    }

    @PostMapping(value={"/balance/deduct"})
    public Rsp deduct(@RequestBody UserBalanceDeductReqBO deductReqBO) {
        return this.tradeBalanceApi.deduct(deductReqBO);
    }

    @PostMapping(value={"/balance/sys_deduct"})
    public Rsp sysDeduct(@RequestBody UserBalanceDeductReqBO deductReqBO) {
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{deductReqBO.getDeductTenantCode(), deductReqBO.getDeductUserId()})) {
                deductReqBO.setTenantCode(deductReqBO.getDeductTenantCode());
                deductReqBO.setUserId(deductReqBO.getDeductUserId());
                return this.tradeBalanceApi.deduct(deductReqBO);
            }
            return BaseRspUtils.createErrorRsp((String)"\u4f59\u989d\u6263\u51cf\u5f02\u5e38");
        }
        catch (Exception e) {
            log.error("\u4f59\u989d\u6263\u51cf-\u5f02\u5e38: {}", (Object)deductReqBO, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u4f59\u989d\u6263\u51cf\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/balance/refund"})
    public Rsp refund(@RequestBody UserBalanceRefundReqBO refundReqBO) {
        return this.tradeBalanceApi.refund(refundReqBO);
    }

    @PostMapping(value={"/bill/list"})
    public RspList<UserBillRecordBO> getBillRecord(@RequestBody UserBillRecordQueryReqBO queryReqBO) {
        return this.tradeBillRecordApi.getBillRecord(queryReqBO);
    }
}

