/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.tydic.nbchat.user.api.bo.WxSchemeBO;
import com.tydic.nbchat.user.core.enmus.WxEventEnum;
import com.tydic.nbchat.user.core.utils.XmlUtils;
import com.tydic.nbchat.user.core.wx.WxAuthHelper;
import com.tydic.nbchat.user.core.wx.WxMsgHelper;
import com.tydic.nbchat.user.core.wx.base.MessageFactory;
import com.tydic.nbchat.user.core.wx.context.WxExtMsgContext;
import com.tydic.nbchat.user.core.wx.event.EventFactory;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user/wx"})
public class WxController {
    private static final Logger log = LoggerFactory.getLogger(WxController.class);
    private static final String token = "9f2579aa49f14c779cd40e55a6eaae51";
    private final EventFactory eventFactory;
    private final MessageFactory messageFactory;
    private final WxAuthHelper wxAuthHelper;
    private final RedisHelper redisHelper;
    private final WxMsgHelper wxMsgHelper;

    public WxController(EventFactory eventFactory, WxAuthHelper wxAuthHelper, RedisHelper redisHelper, WxMsgHelper wxMsgHelper, MessageFactory messageFactory) {
        this.eventFactory = eventFactory;
        this.wxAuthHelper = wxAuthHelper;
        this.redisHelper = redisHelper;
        this.wxMsgHelper = wxMsgHelper;
        this.messageFactory = messageFactory;
    }

    @RequestMapping(value={"callback"}, method={RequestMethod.GET, RequestMethod.POST})
    public void wxCallback(HttpServletRequest request, HttpServletResponse response) {
        if (RequestMethod.GET.toString().equals(request.getMethod())) {
            Map parameterMap = request.getParameterMap();
            log.info("\u6536\u5230\u5fae\u4fe1\u516c\u4f17\u53f7\u56de\u8c03\u901a\u77e5-get-\u5f00\u59cb: {}", (Object)parameterMap);
            this.activate(request, response);
        }
        if (RequestMethod.POST.toString().equals(request.getMethod())) {
            String requestBody = this.getRequestBody(request);
            log.info("\u6536\u5230\u5fae\u4fe1\u516c\u4f17\u53f7\u56de\u8c03\u901a\u77e5-post-\u5f00\u59cb: {}", (Object)requestBody);
            WxExtMsgContext context = XmlUtils.parseWithJackson(requestBody);
            String eventKey = context.getFromUserName() + context.getCreateTime();
            if (this.redisHelper.hasKey(eventKey)) {
                log.warn("\u91cd\u590d\u6536\u5230\u5fae\u4fe1\u4e8b\u4ef6\u56de\u8c03:{}", (Object)context);
                this.setResponseContent(response, "");
                return;
            }
            this.redisHelper.set(eventKey, (Object)context, 5L);
            if (StringUtils.isNotEmpty((CharSequence)context.getEvent())) {
                Rsp rsp = this.eventFactory.handle(context);
                if (!rsp.isSuccess()) {
                    this.setResponseContent(response, "");
                    return;
                }
                this.setResponseContent(response, rsp.getData());
                if (context.getEvent().equals(WxEventEnum.SCAN.getCode())) {
                    this.wxMsgHelper.sendImageMsg(context.getFromUserName());
                }
            } else {
                Rsp rsp = this.messageFactory.handle(context);
                if (!rsp.isSuccess()) {
                    log.error("\u5904\u7406\u5fae\u4fe1\u6d88\u606f\u5931\u8d25:{}|{}", (Object)context, (Object)rsp);
                    this.setResponseContent(response, "");
                    return;
                }
                this.setResponseContent(response, rsp.getData());
                this.wxMsgHelper.sendImageMsg(context.getFromUserName());
            }
        }
    }

    @GetMapping(value={"qrcode"})
    public Rsp getQrcode(@RequestParam(value="sessionKey") String sessionKey) {
        String qrUrl = this.wxAuthHelper.getQrUrl(sessionKey);
        return BaseRspUtils.createSuccessRsp((Object)qrUrl);
    }

    @PostMapping(value={"sendMsg"})
    public Rsp sendMsg(@RequestParam(value="userId") String userId, @RequestParam(value="content") String content) {
        return BaseRspUtils.createSuccessRsp((Object)"\u53d1\u9001\u6210\u529f");
    }

    @PostMapping(value={"scheme"})
    public Rsp getScheme(@RequestBody WxSchemeBO request) {
        return this.wxAuthHelper.generateScheme(request.getPath(), request.getQuery(), request.getEnv());
    }

    private void setResponseContent(HttpServletResponse response, Object content) {
        try {
            String xml = XmlUtils.parseWithXml(content);
            response.getOutputStream().write(xml.getBytes(StandardCharsets.UTF_8));
            response.getOutputStream().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getRequestBody(HttpServletRequest request) {
        String requestBody = null;
        try {
            requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return requestBody;
    }

    public void activate(HttpServletRequest request, HttpServletResponse response) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        log.info("\u6fc0\u6d3b\u5fae\u4fe1\u5f00\u53d1\u8005\u8d26\u53f7:{}|{}|{}", new Object[]{signature, timestamp, nonce});
        List<String> params = Arrays.asList(token, timestamp, nonce);
        Collections.sort(params);
        String combinedParams = String.join((CharSequence)"", params);
        String encryptedParams = DigestUtils.sha1Hex((String)combinedParams);
        if (signature.equals(encryptedParams)) {
            try {
                response.getOutputStream().write(request.getParameter("echostr").getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }
}

