/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.web;

import com.tydic.nbchat.user.core.busi.WxMiniProgramService;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user/wx/mp"})
public class WxMiniProgramController {
    private static final Logger log = LoggerFactory.getLogger(WxMiniProgramController.class);
    private final WxMiniProgramService miniProgramService;

    public WxMiniProgramController(WxMiniProgramService miniProgramService) {
        this.miniProgramService = miniProgramService;
    }

    @GetMapping(value={"qrcode/{scene}"})
    public void qrcode(HttpServletResponse response, @PathVariable(value="scene") String scene) {
        log.info("\u751f\u6210\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\uff1a{}", (Object)scene);
        try {
            byte[] bytes = this.miniProgramService.generateQrCode(scene);
            if (bytes == null) {
                response.setStatus(500);
            } else {
                response.setContentType("image/jpeg");
                response.setHeader("Content-Disposition", "attachment; filename=\"qrcode.jpg\"");
                response.getOutputStream().write(bytes);
                response.getOutputStream().flush();
            }
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u5f02\u5e38", (Throwable)e);
        }
    }
}

