/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.wx;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.utils.RedisKeyUtils;
import com.tydic.nbchat.user.core.config.WchatConfigProperties;
import com.tydic.nbchat.user.core.enmus.WxChannelEnum;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxAuthHelper {
    private static final Logger log = LoggerFactory.getLogger(WxAuthHelper.class);
    private final WchatConfigProperties wchatConfigProperties;
    private final RestApiHelper restApiHelper;
    private final RedisHelper redisHelper;
    private static final String wxSchemeUrl = "https://api.weixin.qq.com/wxa/generatescheme?access_token=";
    private static final String default_path = "/pages/index/index";
    private static final String default_env = "release";

    public WxAuthHelper(WchatConfigProperties wchatConfigProperties, RestApiHelper restApiHelper, RedisHelper redisHelper) {
        this.wchatConfigProperties = wchatConfigProperties;
        this.restApiHelper = restApiHelper;
        this.redisHelper = redisHelper;
    }

    public String getAccessToken(String channel) {
        String key = RedisKeyUtils.getAccessTokenKey((String)channel);
        String accessToken = (String)this.redisHelper.get(key);
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            log.info("\u7b7e\u540d-\u83b7\u53d6access_token\u6210\u529f1:{}", (Object)accessToken);
            return accessToken;
        }
        WchatConfigProperties.Property property = this.wchatConfigProperties.getChannels().get(channel);
        String appId = property.getAppId();
        String appSecret = property.getSecret();
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("grant_type", "client_credential");
        paramMap.put("appid", appId);
        paramMap.put("secret", appSecret);
        String response = this.restApiHelper.get("https://api.weixin.qq.com/cgi-bin/token", "", paramMap);
        JSONObject accessTokenJson = JSONObject.parseObject((String)response);
        if (accessTokenJson.containsKey((Object)"access_token")) {
            accessToken = accessTokenJson.getString("access_token");
            this.redisHelper.set(key, (Object)accessToken, 5400L);
            log.info("\u7b7e\u540d-\u83b7\u53d6access_token\u6210\u529f2:{}", (Object)accessToken);
            return accessToken;
        }
        log.error("\u7b7e\u540d-\u83b7\u53d6access_token\u9519\u8bef:{}", (Object)accessTokenJson.getString("errmsg"));
        return null;
    }

    public String getWxUserUnionid(String openId) {
        String accessToken = this.getAccessToken(WxChannelEnum.OFFICIAL_ACCOUNTS.getCode());
        String wxUserInfoUrl = this.wchatConfigProperties.getWxUserInfoUrl();
        String res = this.restApiHelper.get(wxUserInfoUrl = wxUserInfoUrl.replace("ACCESS_TOKEN", accessToken).replace("OPENID", openId), "", new LinkedHashMap());
        if (JSON.isValid((String)res)) {
            JSONObject jsonObject = JSONObject.parseObject((String)res);
            return jsonObject.getString("unionid");
        }
        return "";
    }

    public String getQrUrl(String sessionKey) {
        log.info("\u83b7\u53d6\u516c\u4f17\u53f7\u4e8c\u7ef4\u7801:{}", (Object)sessionKey);
        String key = RedisKeyUtils.getQrcodeKey((String)sessionKey);
        JSONObject wxQrObj = (JSONObject)this.redisHelper.get(key);
        if (ObjectUtils.isNotEmpty((Object)wxQrObj) && StringUtils.isNotEmpty((CharSequence)wxQrObj.get((Object)"qrUrl").toString())) {
            return wxQrObj.get((Object)"qrUrl").toString();
        }
        String body = "{\"expire_seconds\": 1800,\"action_name\":\"QR_STR_SCENE\",\"action_info\":{\"scene\":{\"scene_str\":\"key\"}}}";
        body = body.replace("key", sessionKey);
        String accessToken = this.getAccessToken(WxChannelEnum.OFFICIAL_ACCOUNTS.getCode());
        String url = this.wchatConfigProperties.getWxQrcodeUrl() + accessToken;
        String res = this.restApiHelper.post(url, body);
        JSONObject jsonObject = JSONObject.parseObject((String)res);
        String wxQrUrl = jsonObject.get((Object)"url").toString();
        this.saveQrInfoCache(key, wxQrUrl, null);
        return wxQrUrl;
    }

    public void saveQrInfoCache(String key, String qrUrl, NbchatUserInfo userInfo) {
        if (StringUtils.isNotEmpty((CharSequence)qrUrl)) {
            JSONObject obj = new JSONObject();
            obj.put("qrUrl", (Object)qrUrl);
            this.redisHelper.set(key, (Object)obj, 1800L);
        } else {
            JSONObject jsonObject = (JSONObject)this.redisHelper.get(key);
            if (ObjectUtils.isEmpty((Object)jsonObject)) {
                log.warn("\u516c\u4f17\u53f7\u767b\u5f55-\u7528\u6237\u767b\u5f55\u4e8c\u7ef4\u7801\u7f13\u5b58\u4fe1\u606f\u5df2\u5931\u6548\uff1a{}", (Object)key);
                jsonObject = new JSONObject();
            }
            jsonObject.put("userInfo", (Object)userInfo);
            this.redisHelper.set(key, (Object)jsonObject, 30L);
        }
    }

    public Rsp generateScheme(String path, String query, String envVersion) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = default_path;
        }
        if (StringUtils.isEmpty((CharSequence)envVersion)) {
            envVersion = default_env;
        }
        String url = wxSchemeUrl + this.getAccessToken(WxChannelEnum.WCHAT_MP_TDH.getCode());
        JSONObject jumpWxa = new JSONObject();
        jumpWxa.put("path", (Object)path);
        jumpWxa.put("query", (Object)query);
        jumpWxa.put("env_version", (Object)envVersion);
        JSONObject bodyObj = new JSONObject();
        bodyObj.put("jump_wxa", (Object)jumpWxa);
        bodyObj.put("is_expire", (Object)true);
        bodyObj.put("expire_type", (Object)1);
        bodyObj.put("expire_interval", (Object)1);
        String body = bodyObj.toJSONString();
        String res = this.restApiHelper.post(url, body);
        log.info("\u751f\u6210\u5c0f\u7a0b\u5e8fscheme\u7801:{}", (Object)res);
        JSONObject jsonObject = JSONObject.parseObject((String)res);
        if (jsonObject.getIntValue("errcode") == 0) {
            return BaseRspUtils.createSuccessRsp((Object)jsonObject.getString("openlink"));
        }
        return BaseRspUtils.createErrorRsp((String)"\u751f\u6210\u5c0f\u7a0b\u5e8fscheme\u7801\u5931\u8d25");
    }
}

