/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.wx;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.bo.eums.WxTemplateEnum;
import com.tydic.nbchat.user.api.bo.notice.NoticeContext;
import com.tydic.nbchat.user.core.config.WchatConfigProperties;
import com.tydic.nbchat.user.core.enmus.WxChannelEnum;
import com.tydic.nbchat.user.core.wx.WxAuthHelper;
import com.tydic.nbchat.user.core.wx.message.ImageMsg;
import com.tydic.nbchat.user.core.wx.message.MsgType;
import com.tydic.nbchat.user.core.wx.message.TemplateMsg;
import com.tydic.nbchat.user.core.wx.message.TextMsg;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxMsgHelper {
    private static final Logger log = LoggerFactory.getLogger(WxMsgHelper.class);
    private final WchatConfigProperties wchatConfigProperties;
    private final RestApiHelper restApiHelper;
    private final WxAuthHelper wxAuthHelper;

    public WxMsgHelper(WchatConfigProperties wchatConfigProperties, RestApiHelper restApiHelper, RedisHelper redisHelper, WxAuthHelper wxAuthHelper) {
        this.wchatConfigProperties = wchatConfigProperties;
        this.restApiHelper = restApiHelper;
        this.wxAuthHelper = wxAuthHelper;
    }

    public void sendImageMsg(String openId) {
        String accessToken = this.wxAuthHelper.getAccessToken(WxChannelEnum.OFFICIAL_ACCOUNTS.getCode());
        String wxSendMsgUrl = this.wchatConfigProperties.getWxSendMsg();
        wxSendMsgUrl = wxSendMsgUrl.replace("ACCESS_TOKEN", accessToken);
        String media_id = this.wchatConfigProperties.getWxScanPushImage();
        ImageMsg imageMsg = ImageMsg.builder().touser(openId).msgtype(MsgType.image.name()).image(new ImageMsg.Image(media_id)).build();
        this.restApiHelper.post(wxSendMsgUrl, (Object)imageMsg);
    }

    public void sendTextMsg(String openId, String content) {
        log.info("\u53d1\u9001\u6587\u672c\u6d88\u606f,openId:{},content:{}", (Object)openId, (Object)content);
        String accessToken = this.wxAuthHelper.getAccessToken(WxChannelEnum.OFFICIAL_ACCOUNTS.getCode());
        String wxSendMsgUrl = this.wchatConfigProperties.getWxSendMsg();
        wxSendMsgUrl = wxSendMsgUrl.replace("ACCESS_TOKEN", accessToken);
        TextMsg textMsg = TextMsg.builder().touser(openId).msgtype(MsgType.text.name()).text(new TextMsg.Text(content)).build();
        this.restApiHelper.post(wxSendMsgUrl, (Object)textMsg);
    }

    public void sendTemplateMsg(String toUser, NoticeContext context) {
        log.info("\u53d1\u9001\u6a21\u677f\u6d88\u606f,toUser=[{}],{}", (Object)toUser, (Object)context);
        String accessToken = this.wxAuthHelper.getAccessToken(WxChannelEnum.OFFICIAL_ACCOUNTS.getCode());
        String templateMsgUrl = this.wchatConfigProperties.getTemplateMsgUrl();
        templateMsgUrl = templateMsgUrl.replace("ACCESS_TOKEN", accessToken);
        Map<String, WchatConfigProperties.TemplateParam> keyMap = this.wchatConfigProperties.getTemplates();
        WchatConfigProperties.TemplateParam tempInfo = keyMap.get(context.getTemplateType());
        List<String> keys = tempInfo.getKeys();
        JSONObject data = new JSONObject();
        for (int i = 0; i < keys.size(); ++i) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("value", context.getParams().get(i));
            data.put(keys.get(i), (Object)jsonObject);
        }
        TemplateMsg msg = TemplateMsg.builder().touser(toUser).template_id(tempInfo.getTemplateId()).data(data).build();
        if (StringUtils.isNotEmpty((CharSequence)context.getUrl())) {
            msg.setUrl(context.getUrl());
        }
        if (WxTemplateEnum.VIDEO.getCode().equals(context.getTemplateType()) && StringUtils.isNotEmpty((CharSequence)context.getPath())) {
            WchatConfigProperties.Property property = this.wchatConfigProperties.getChannels().get("tdh_mp");
            JSONObject miniprogram = new JSONObject();
            miniprogram.put("appid", (Object)property.getAppId());
            miniprogram.put("pagepath", (Object)context.getPath());
            msg.setMiniprogram(miniprogram);
        }
        log.info("\u53d1\u9001\u6a21\u677f\u6d88\u606f,msg=[{}]", (Object)JSONObject.toJSONString((Object)msg));
        this.restApiHelper.post(templateMsgUrl, (Object)msg);
    }
}

