/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.wx;

import com.tydic.nbchat.user.api.bo.notice.NoticeContext;
import com.tydic.nbchat.user.core.wx.WxMsgHelper;
import com.tydic.nbchat.user.mapper.WxUserMapper;
import com.tydic.nbchat.user.mapper.po.WxUserPO;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxSendMsgService {
    private static final Logger log = LoggerFactory.getLogger(WxSendMsgService.class);
    private final WxMsgHelper wxMsgHelper;
    @Resource
    WxUserMapper wxUserMapper;

    public WxSendMsgService(WxMsgHelper wxMsgHelper) {
        this.wxMsgHelper = wxMsgHelper;
    }

    public void sendTemplateMsg(NoticeContext context) {
        try {
            WxUserPO wxUserPO = this.wxUserMapper.queryOAByUserId(context.getUserId());
            if (ObjectUtils.isEmpty((Object)wxUserPO)) {
                log.warn("\u5fae\u4fe1\u7528\u6237\u4e0d\u5b58\u5728,userId:{}", (Object)context.getUserId());
                return;
            }
            this.wxMsgHelper.sendTemplateMsg(wxUserPO.getOpenId(), context);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5931\u8d25,userId:{},templateType:{},params:{}", new Object[]{context.getUserId(), context.getTemplateType(), context.getParams(), e});
        }
    }

    public void sendTextMsg(String userId, String content) {
        try {
            WxUserPO wxUserPO = this.wxUserMapper.queryOAByUserId(userId);
            if (ObjectUtils.isEmpty((Object)wxUserPO)) {
                log.warn("\u5fae\u4fe1\u7528\u6237\u4e0d\u5b58\u5728,userId:{}", (Object)userId);
                return;
            }
            this.wxMsgHelper.sendTextMsg(wxUserPO.getOpenId(), content);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6587\u672c\u6d88\u606f\u5931\u8d25,userId:{},content:{}", new Object[]{userId, content, e});
        }
    }
}

