/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.wx.base;

import com.tydic.nbchat.user.core.wx.base.api.MessageHandler;
import com.tydic.nbchat.user.core.wx.context.WxExtMsgContext;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageFactory {
    private static final Logger log = LoggerFactory.getLogger(MessageFactory.class);
    protected final Map<String, MessageHandler> eventMap = new HashMap<String, MessageHandler>();

    public MessageFactory(List<MessageHandler> eventHandlers) {
        this.initMsgTypeMap(eventHandlers);
    }

    private void initMsgTypeMap(List<MessageHandler> eventHandlers) {
        eventHandlers.forEach(messageHandler -> this.eventMap.put(messageHandler.msgType(), (MessageHandler)messageHandler));
    }

    protected MessageHandler getEventHandler(String msgType) {
        return this.eventMap.get(msgType);
    }

    public Rsp handle(WxExtMsgContext context) {
        MessageHandler eventHandler = this.getEventHandler(context.getMsgType());
        if (eventHandler == null) {
            log.warn("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d88\u606f\u7c7b\u578b\u5904\u7406\u5668:{}", (Object)context);
            return BaseRspUtils.createErrorRsp((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d88\u606f\u7c7b\u578b\u5904\u7406\u5668");
        }
        return eventHandler.handle(context);
    }
}

