/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.wx.event;

import com.tydic.nbchat.user.core.wx.context.WxExtMsgContext;
import com.tydic.nbchat.user.core.wx.event.api.EventHandler;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EventFactory {
    private static final Logger log = LoggerFactory.getLogger(EventFactory.class);
    protected final Map<String, EventHandler> eventMap = new HashMap<String, EventHandler>();

    public EventFactory(List<EventHandler> eventHandlers) {
        this.initEventMap(eventHandlers);
    }

    private void initEventMap(List<EventHandler> eventHandlers) {
        eventHandlers.forEach(eventHandler -> this.eventMap.put(eventHandler.event(), (EventHandler)eventHandler));
    }

    protected EventHandler getEventHandler(String event) {
        return this.eventMap.get(event);
    }

    public Rsp handle(WxExtMsgContext context) {
        EventHandler eventHandler = this.getEventHandler(context.getEvent());
        if (eventHandler == null) {
            log.warn("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e8b\u4ef6\u5904\u7406\u5668:{}", (Object)context);
            return BaseRspUtils.createErrorRsp((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e8b\u4ef6\u5904\u7406\u5668");
        }
        return eventHandler.handle(context);
    }
}

