/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.wx.event.handler;

import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.AuthType;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.utils.RedisKeyUtils;
import com.tydic.nbchat.user.core.config.WchatConfigProperties;
import com.tydic.nbchat.user.core.enmus.WxEventEnum;
import com.tydic.nbchat.user.core.wx.WxAuthHelper;
import com.tydic.nbchat.user.core.wx.context.WxExtMsgContext;
import com.tydic.nbchat.user.core.wx.context.WxMsgBaseContext;
import com.tydic.nbchat.user.core.wx.context.WxTextMsgContext;
import com.tydic.nbchat.user.core.wx.event.api.EventHandler;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FollowingEventHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(FollowingEventHandler.class);
    @Resource
    WxAuthHelper wxAuthHelper;
    @Resource
    NbchatUserApi nbchatUserApi;
    @Resource
    WchatConfigProperties wchatConfigProperties;

    @Override
    public String event() {
        return WxEventEnum.SUBSCRIBE.getCode();
    }

    @Override
    public <T extends WxMsgBaseContext> Rsp<?> handle(T eventMsg) {
        log.info("\u5904\u7406\u8ba2\u9605\u4e8b\u4ef6:{}", eventMsg);
        String wxUserUnionId = this.wxAuthHelper.getWxUserUnionid(eventMsg.getFromUserName());
        if (StringUtils.isEmpty((CharSequence)wxUserUnionId)) {
            log.error("\u83b7\u53d6unionId\u5931\u8d25:{}", (Object)eventMsg.getFromUserName());
            return BaseRspUtils.createErrorRsp((String)"");
        }
        AuthUserReqBO auth = AuthUserReqBO.builder().authType(AuthType.WCHAT_PC_OFFICIAL.getCode()).openId(eventMsg.getFromUserName()).unionId(wxUserUnionId).loginClient(JoinTenantType.KE_JIAN_Bang.getName()).build();
        Rsp rsp = this.nbchatUserApi.authUser(auth);
        if (rsp.isSuccess()) {
            WxExtMsgContext extMsgContext = (WxExtMsgContext)eventMsg;
            log.info("\u8ba4\u8bc1\u901a\u8fc7\uff0c\u8bbe\u7f6e\u7f13\u5b58:{}", (Object)extMsgContext);
            if (StringUtils.isNotEmpty((CharSequence)extMsgContext.getEventKey())) {
                String sessionKey = extMsgContext.getEventKey().replace("qrscene_", "");
                String key = RedisKeyUtils.getQrcodeKey((String)sessionKey);
                this.wxAuthHelper.saveQrInfoCache(key, null, (NbchatUserInfo)rsp.getData());
            }
        } else {
            log.error("\u8ba4\u8bc1\u5931\u8d25:{}", (Object)rsp);
            return BaseRspUtils.createErrorRsp((String)"");
        }
        WxTextMsgContext context = this.buildResponseContext(eventMsg, this.wchatConfigProperties.getFollowingContent());
        return BaseRspUtils.createSuccessRsp((Object)context);
    }
}

