/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.wx.event.handler;

import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.AuthType;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.utils.RedisKeyUtils;
import com.tydic.nbchat.user.core.busi.WxUserService;
import com.tydic.nbchat.user.core.enmus.WxChannelEnum;
import com.tydic.nbchat.user.core.enmus.WxEventEnum;
import com.tydic.nbchat.user.core.wx.WxAuthHelper;
import com.tydic.nbchat.user.core.wx.context.WxExtMsgContext;
import com.tydic.nbchat.user.core.wx.context.WxMsgBaseContext;
import com.tydic.nbchat.user.core.wx.context.WxTextMsgContext;
import com.tydic.nbchat.user.core.wx.event.api.EventHandler;
import com.tydic.nbchat.user.mapper.po.WxUserPO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScanEventHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(ScanEventHandler.class);
    @Resource
    WxAuthHelper wxAuthHelper;
    @Resource
    NbchatUserApi nbchatUserApi;
    private final WxUserService wxUserService;

    public ScanEventHandler(WxUserService wxUserService) {
        this.wxUserService = wxUserService;
    }

    @Override
    public String event() {
        return WxEventEnum.SCAN.getCode();
    }

    @Override
    public <T extends WxMsgBaseContext> Rsp<?> handle(T eventMsg) {
        log.info("\u5904\u7406\u626b\u7801\u4e8b\u4ef6:{}", eventMsg);
        String wxUserUnionId = this.wxAuthHelper.getWxUserUnionid(eventMsg.getFromUserName());
        if (StringUtils.isEmpty((CharSequence)wxUserUnionId)) {
            log.error("\u83b7\u53d6unionId\u5931\u8d25:{}", (Object)eventMsg.getFromUserName());
            return BaseRspUtils.createErrorRsp((String)"");
        }
        AuthUserReqBO auth = AuthUserReqBO.builder().authType(AuthType.WCHAT_PC_OFFICIAL.getCode()).loginClient(JoinTenantType.KE_JIAN_Bang.getName()).openId(eventMsg.getFromUserName()).unionId(wxUserUnionId).build();
        Rsp rsp = this.nbchatUserApi.authUser(auth);
        if (rsp.isSuccess()) {
            WxExtMsgContext extMsgContext = (WxExtMsgContext)eventMsg;
            log.info("\u8ba4\u8bc1\u901a\u8fc7\uff0c\u8bbe\u7f6e\u7f13\u5b58:{}", (Object)extMsgContext);
            if (StringUtils.isNotEmpty((CharSequence)extMsgContext.getEventKey())) {
                String key = RedisKeyUtils.getQrcodeKey((String)extMsgContext.getEventKey());
                this.wxAuthHelper.saveQrInfoCache(key, null, (NbchatUserInfo)rsp.getData());
            }
        } else {
            log.error("\u8ba4\u8bc1\u5931\u8d25:{}", (Object)rsp);
            return BaseRspUtils.createErrorRsp((String)"");
        }
        this.updateWxUser((NbchatUserInfo)rsp.getData(), eventMsg.getFromUserName(), wxUserUnionId);
        WxTextMsgContext context = this.buildResponseContext(eventMsg, "\u767b\u5f55\u6210\u529f\uff01\n\n\u626b\u63cf\u4e0b\u65b9\u4e8c\u7ef4\u7801\n\u83b7\u53d61v1\u4e13\u5c5e\u5ba2\u670d");
        return BaseRspUtils.createSuccessRsp((Object)context);
    }

    public void updateWxUser(NbchatUserInfo userInfo, String openId, String unionId) {
        WxUserPO userPO = this.wxUserService.query(openId);
        if (ObjectUtils.isNotEmpty((Object)userPO)) {
            userPO.setChannel(WxChannelEnum.KEJIANBANG.getCode());
            userPO.setUpdatedTime(new Date());
            this.wxUserService.update(userPO);
        } else {
            WxUserPO po = new WxUserPO();
            po.setOpenId(openId);
            po.setTenantCode(userInfo.getTenantCode());
            po.setChannel(WxChannelEnum.KEJIANBANG.getCode());
            po.setUserId(userInfo.getUserId());
            po.setUnionId(unionId);
            po.setCreatedTime(new Date());
            this.wxUserService.save(po);
        }
    }
}

