/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab;

import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcrontab.Crontab;
import org.jcrontab.CrontabBean;
import org.jcrontab.data.CalendarBuilder;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryDAO;
import org.jcrontab.data.DataNotFoundException;

public class Cron
extends Thread {
    private static final Log Log = LogFactory.getLog(Cron.class);
    private static boolean shouldRun = true;
    private static final String GENERATE_TIMETABLE_EVENT = "gen_timetable";
    private Crontab crontab;
    private static int iFrec;
    private static int minute;
    public static Properties prop;
    private static CrontabBean[] eventsQueue;
    private static CrontabEntryBean[] crontabEntryArray;
    private static CalendarBuilder calb;
    private static final String LOAD_TIME_PROPERTY;
    private long myClassLoadTime = Long.parseLong(System.getProperty(LOAD_TIME_PROPERTY));

    static {
        minute = 60000;
        prop = null;
        crontabEntryArray = null;
        calb = null;
        LOAD_TIME_PROPERTY = String.valueOf(Cron.class.getName()) + ".load-time";
        System.setProperty(LOAD_TIME_PROPERTY, String.valueOf(System.currentTimeMillis()));
    }

    public Cron() {
        this.crontab = Crontab.getInstance();
        iFrec = 3600;
        calb = new CalendarBuilder();
    }

    public Cron(Crontab cront, int iTimeTableGenerationFrec) {
        this.crontab = cront;
        iFrec = iTimeTableGenerationFrec * 60;
    }

    private boolean isClassReloaded() {
        if (this.myClassLoadTime != Long.parseLong(System.getProperty(LOAD_TIME_PROPERTY))) {
            Log.info((Object)"This class has been reloaded, so I am a runaway daemon. Canceling.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int counter = 0;
        Log.info((Object)"JCRONTAB\u4e3b\u7ebf\u7a0b\u542f\u52a8....");
        try {
            this.generateTasks();
        }
        catch (Exception e) {
            Log.error((Object)e.toString(), (Throwable)e);
        }
        while (shouldRun) {
            try {
                if (this.isInterrupted()) {
                    Cron.interrupted();
                    throw new Exception();
                }
                CrontabBean nextEv = eventsQueue[counter];
                long intervalToSleep = nextEv.getTime() - System.currentTimeMillis();
                if (intervalToSleep > 0L) {
                    Cron cron = this;
                    synchronized (cron) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((Object)("Interval to sleep : " + intervalToSleep));
                        }
                        this.wait(intervalToSleep);
                    }
                }
                ++counter;
                if (nextEv.getClassName().equals(GENERATE_TIMETABLE_EVENT)) {
                    this.generateTasks();
                    counter = 0;
                    continue;
                }
                if (!Log.isDebugEnabled()) continue;
                Log.debug((Object)nextEv.getExtraInfo());
            }
            catch (Exception e) {
                if (!shouldRun) break;
                counter = 0;
                this.generateTasks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitNextMinute() {
        long intervalToSleep;
        Object nextCeb;
        long tmp = System.currentTimeMillis();
        if (crontabEntryArray != null) {
            nextCeb = calb.getNextCrontabEntry(crontabEntryArray);
            intervalToSleep = calb.buildCalendar((CrontabEntryBean)nextCeb).getTime();
        } else {
            intervalToSleep = (tmp / (long)minute + 1L) * (long)minute - tmp;
        }
        try {
            nextCeb = this;
            synchronized (nextCeb) {
                Log.debug((Object)("this is the interval to sleep : " + intervalToSleep));
                this.wait(intervalToSleep);
            }
        }
        catch (InterruptedException e) {
            this.waitNextMinute();
        }
    }

    public static void stopInTheNextMinute() {
        shouldRun = false;
    }

    private static CrontabEntryBean[] readCrontab() throws Exception {
        crontabEntryArray = CrontabEntryDAO.getInstance().findAll();
        return crontabEntryArray;
    }

    public void generateTasks() {
        try {
            crontabEntryArray = null;
            crontabEntryArray = Cron.readCrontab();
            Vector<CrontabBean> lista1 = new Vector<CrontabBean>();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(System.currentTimeMillis()));
            int i = 0;
            while (i < iFrec) {
                int j = 0;
                while (j < crontabEntryArray.length) {
                    if (crontabEntryArray[j].equals(cal) && Cron.shouldRunToday(crontabEntryArray[j].getBusinessDays())) {
                        CrontabBean ev = new CrontabBean();
                        ev.setId(j);
                        ev.setCalendar(cal);
                        ev.setTime(cal.getTime().getTime());
                        ev.setClassName(crontabEntryArray[j].getClassName());
                        ev.setMethodName(crontabEntryArray[j].getMethodName());
                        ev.setExtraInfo(crontabEntryArray[j].getExtraInfo());
                        lista1.add(ev);
                    }
                    ++j;
                }
                cal.add(13, 1);
                ++i;
            }
            CrontabBean ev = new CrontabBean();
            ev.setCalendar(cal);
            ev.setTime(cal.getTime().getTime());
            ev.setClassName(GENERATE_TIMETABLE_EVENT);
            ev.setMethodName("");
            lista1.add(ev);
            eventsQueue = new CrontabBean[lista1.size()];
            int i2 = 0;
            while (i2 < lista1.size()) {
                Cron.eventsQueue[i2] = (CrontabBean)lista1.get(i2);
                ++i2;
            }
        }
        catch (Exception e) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(System.currentTimeMillis() / 60000L * 60000L));
            cal.add(13, iFrec);
            CrontabBean ev = new CrontabBean();
            ev.setCalendar(cal);
            ev.setTime(cal.getTime().getTime());
            ev.setClassName(GENERATE_TIMETABLE_EVENT);
            ev.setMethodName("");
            eventsQueue = new CrontabBean[1];
            Cron.eventsQueue[0] = ev;
            if (e instanceof DataNotFoundException) {
                Log.info((Object)e.toString());
            }
            Log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private static boolean shouldRunToday(boolean should) throws Exception {
        if (!Crontab.getInstance().isHoliday()) {
            return true;
        }
        return should;
    }
}

