/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab;

import com.chinaunicom.timer.crontab.CrontabHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.jcrontab.Cron;
import org.jcrontab.CronTask;
import org.jcrontab.data.DefaultFiles;
import org.jcrontab.data.HoliDay;
import org.jcrontab.data.HoliDayFactory;
import org.jcrontab.log.Log;

public class Crontab {
    private String version = "2.0.RC1";
    private HashMap tasks = new HashMap();
    private HashMap loadedClasses = new HashMap();
    private int iNextTaskID = 1;
    private Properties prop = null;
    private int iTimeTableGenerationFrec = 3;
    private Cron cron;
    private boolean stoping = false;
    private boolean daemon = true;
    private static String strFileName = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".jcrontab" + System.getProperty("file.separator") + "jcrontab.properties";
    private boolean isInternalConfig = true;
    private static Crontab singleton = null;

    private Crontab() {
    }

    public static synchronized Crontab getInstance() {
        System.out.println("----Crontab------getInstance----");
        if (singleton == null) {
            singleton = new Crontab();
        }
        return singleton;
    }

    public void init() throws Exception {
        this.loadConfig();
        this.cron = new Cron(this, this.iTimeTableGenerationFrec);
        this.cron.setName("Cron");
        this.cron.setDaemon(this.daemon);
        this.cron.start();
        this.stoping = false;
    }

    public void init(String strFileName) throws Exception {
        Crontab.strFileName = strFileName;
        this.loadConfig();
        String refreshFrequency = this.getProperty("org.jcrontab.Crontab.refreshFrequency");
        if (refreshFrequency != null) {
            this.iTimeTableGenerationFrec = Integer.parseInt(refreshFrequency);
        }
        this.cron = new Cron(this, this.iTimeTableGenerationFrec);
        this.isInternalConfig = true;
        this.cron.setName("Cron");
        this.cron.setDaemon(this.daemon);
        this.cron.start();
        this.stoping = false;
    }

    public void init(Properties props) throws Exception {
        strFileName = null;
        String refreshFrequency = props.getProperty("org.jcrontab.Crontab.refreshFrequency");
        this.prop = props;
        if (refreshFrequency != null) {
            this.iTimeTableGenerationFrec = Integer.parseInt(refreshFrequency);
        }
        this.cron = new Cron(this, this.iTimeTableGenerationFrec);
        this.cron.setName("Cron");
        this.cron.setDaemon(this.daemon);
        this.cron.start();
        this.stoping = false;
    }

    public void uninit() {
        if (this.stoping) {
            return;
        }
        this.stoping = true;
        Cron.stopInTheNextMinute();
        this.cron.interrupt();
    }

    public void uninit(int iSecondsToWait) {
        if (this.stoping) {
            return;
        }
        try {
            this.stoping = true;
            Cron.stopInTheNextMinute();
            this.cron.interrupt();
            CronTask[] tasks = this.getAllTasks();
            int i = tasks.length - 1;
            while (i >= 0) {
                tasks[i].join(iSecondsToWait);
                --i;
            }
        }
        catch (InterruptedException e) {
            Log.error(e.toString(), e);
        }
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void loadConfig() throws Exception {
        if (strFileName.indexOf("\\") != -1) {
            strFileName = strFileName.replace('\\', '/');
        }
        if (this.prop == null) {
            this.prop = new Properties();
        }
        try {
            File filez = new File(strFileName);
            FileInputStream input = new FileInputStream(filez);
            this.prop.load(input);
            input.close();
            Enumeration<?> e = this.prop.propertyNames();
            while (e.hasMoreElements()) {
                String ss = (String)e.nextElement();
                Log.debug(String.valueOf(ss) + " : " + this.prop.getProperty(ss));
            }
        }
        catch (FileNotFoundException fnfe) {
            if (this.isInternalConfig) {
                DefaultFiles.createJcrontabDir();
                DefaultFiles.createCrontabFile();
                DefaultFiles.createPropertiesFile();
                this.loadConfig();
            }
            throw new FileNotFoundException("Unable to find: " + strFileName);
        }
        this.prop.setProperty("org.jcrontab.config", strFileName);
        this.prop.setProperty("org.jcrontab.version", this.version);
    }

    public Properties getConfig() {
        if (this.prop == null) {
            try {
                this.loadConfig();
            }
            catch (Exception e) {
                Log.error(e.toString(), e);
            }
        }
        return this.prop;
    }

    public void setConfig(String properties) {
        strFileName = properties;
    }

    public String getProperty(String name) {
        return this.prop.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.prop.setProperty(name, value);
    }

    public void removeProperty(String name) {
        this.prop.remove(name);
        try {
            File filez = new File(strFileName);
            filez.delete();
            FileOutputStream out = new FileOutputStream(filez);
            this.prop.store(out, "#");
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            Log.error(e.toString(), e);
        }
    }

    public void storeProperty(String property, String value) {
        this.prop.setProperty(property, value);
        try {
            File filez = new File(strFileName);
            filez.delete();
            FileOutputStream out = new FileOutputStream(filez);
            this.prop.store(out, "#");
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            Log.error(e.toString(), e);
        }
    }

    public boolean isHoliday() throws Exception {
        if (this.getProperty("org.jcrontab.data.holidaysource") == null || this.getProperty("org.jcrontab.data.holidaysource") == "") {
            return false;
        }
        Calendar today = Calendar.getInstance();
        HoliDay[] holidays = HoliDayFactory.getInstance().findAll();
        int i = 0;
        while (i < holidays.length) {
            Calendar holiday = Calendar.getInstance();
            holiday.setTime(holidays[i].getDate());
            if (holiday.get(2) == today.get(2) && holiday.get(5) == today.get(5) && holiday.get(1) == today.get(1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int newTask(String strClassName, String strMethodName, String[] strExtraInfo) {
        if (this.stoping) {
            return -1;
        }
        String params = "";
        try {
            Object classOnlyName;
            int iTaskID = this.iNextTaskID;
            Class cl = (Class)this.loadedClasses.get(strClassName);
            CronTask newTask = new CronTask();
            newTask.setParams(this, iTaskID, strClassName, strMethodName, strExtraInfo);
            int lastDot = strClassName.lastIndexOf(".");
            if (lastDot > 0 && lastDot < strClassName.length()) {
                classOnlyName = strClassName.substring(lastDot + 1);
                newTask.setName((String)classOnlyName);
            }
            classOnlyName = this.tasks;
            synchronized (classOnlyName) {
                this.tasks.put(new Integer(iTaskID), new TaskTableEntry(strClassName, newTask));
            }
            newTask.setName("Crontask-" + iTaskID);
            CrontabHelper.startTask((CronTask)newTask);
            if (strExtraInfo != null && strExtraInfo.length > 0) {
                int i = 0;
                while (i < strExtraInfo.length) {
                    params = String.valueOf(params) + strExtraInfo[i] + " ";
                    ++i;
                }
            }
            Log.info(String.valueOf(strClassName) + "#" + strMethodName + " " + params);
            ++this.iNextTaskID;
            return iTaskID;
        }
        catch (Exception e) {
            Log.error("Smth was wrong with" + strClassName + "#" + strMethodName + " " + params, e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTask(int iTaskID) {
        HashMap hashMap = this.tasks;
        synchronized (hashMap) {
            block4: {
                if (this.tasks.remove(new Integer(iTaskID)) != null) break block4;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronTask[] getAllTasks() {
        CronTask[] t;
        HashMap hashMap = this.tasks;
        synchronized (hashMap) {
            int i = 0;
            t = new CronTask[this.tasks.size()];
            Iterator iter = this.tasks.values().iterator();
            while (iter.hasNext()) {
                t[i] = ((TaskTableEntry)iter.next()).task;
                ++i;
            }
        }
        return t;
    }

    public Cron getCurCron() {
        return this.cron;
    }

    public static void main(String[] args) {
        System.out.println(strFileName);
    }

    private class TaskTableEntry {
        String strClassName;
        CronTask task;

        public TaskTableEntry(String strClassName, CronTask task) {
            this.strClassName = strClassName;
            this.task = task;
        }
    }
}

