/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;

public class CrontabBean
implements Serializable {
    private Calendar cal;
    private long timeMillis;
    private int id;
    private String className;
    private String methodName;
    private boolean bextraInfo = false;
    private String[] extraInfo;

    public void setId(int id) {
        this.id = id;
    }

    public void setTime(long timeMillis) {
        this.timeMillis = timeMillis;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setExtraInfo(String[] extraInfo) {
        this.extraInfo = extraInfo;
        this.bextraInfo = true;
    }

    public void setCalendar(Calendar cal) {
        this.cal = cal;
    }

    public int getId() {
        return this.id;
    }

    public long getTime() {
        return this.timeMillis;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getExtraInfo() {
        return this.extraInfo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n [ Id: " + this.id + " ]");
        sb.append("\n [ ClassName: " + this.className + " ]");
        sb.append("\n [ MethodName : " + this.methodName + " ]");
        if (this.bextraInfo) {
            for (int i = 0; i < this.extraInfo.length; ++i) {
                sb.append("\n [ Parameter " + i + " : " + this.extraInfo[i] + " ]");
            }
        }
        sb.append("\n [ Calendar: " + this.cal + " ]");
        sb.append("\n [ TimeMillis: " + this.timeMillis + " ] ");
        sb.append("\n ");
        return sb.toString();
    }

    public String toXML() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        this.toXML(printWriter);
        return stringWriter.toString();
    }

    public void toXML(PrintWriter pw) {
        pw.println("<crontabentry>");
        pw.println("<id>" + this.id + "</id> ");
        pw.println("<classname>" + this.className + "</classname> ");
        pw.println("<methodname>" + this.methodName + "</methodname> ");
        if (this.bextraInfo) {
            for (int i = 0; i < this.extraInfo.length; ++i) {
                pw.println("<extrainfo parameter = \"" + i + "\" >");
                pw.println(this.extraInfo[i] + " </extrainfo>");
            }
        }
        pw.println("<calendar>" + this.cal + " </calendar>");
        pw.println("<timemillis>" + this.timeMillis + "</timemillis> ");
        pw.println("</crontabentry>");
    }

    public static CrontabBean[] toArray(Object[] obj) {
        CrontabBean[] ceb = new CrontabBean[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ceb[i] = (CrontabBean)obj[i];
        }
        return ceb;
    }
}

