/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jcrontab.Crontab;

public class SendMail {
    private String to = Crontab.getInstance().getProperty("org.jcrontab.SendMail.to");
    private String from = Crontab.getInstance().getProperty("org.jcrontab.SendMail.from");
    private String host = Crontab.getInstance().getProperty("org.jcrontab.SendMail.smtp.host");
    private String username = Crontab.getInstance().getProperty("org.jcrontab.SendMail.smtp.username");
    private String password = Crontab.getInstance().getProperty("org.jcrontab.SendMail.smtp.password");

    private String prepare(File file) throws Exception {
        String line;
        FileInputStream fis = new FileInputStream(file);
        BufferedReader input = new BufferedReader(new InputStreamReader(fis));
        String result = new String();
        while ((line = input.readLine()) != null) {
            result = result + line + "\n";
        }
        return result;
    }

    public void send(File file) throws Exception {
        String body = this.prepare(file);
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        if (this.username != null && this.password != null) {
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.from));
        InternetAddress[] address = new InternetAddress[]{new InternetAddress(this.to)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject("jcrontab");
        msg.setSentDate(new Date());
        msg.setText(body);
        if (this.username != null && this.password != null) {
            Transport transport = session.getTransport("smtp");
            transport.connect(this.host, this.username, this.password);
            Transport.send((Message)msg);
        } else {
            Transport.send((Message)msg);
        }
    }
}

