/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab;

import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.jcrontab.Crontab;

public class TurbineJcrontabScheduler
extends TurbineBaseService {
    private Crontab crontab = null;
    private static Log log = LogFactory.getLog(TurbineJcrontabScheduler.class);
    static final String SERVICE_NAME = "JCrontab";

    public Crontab getScheduler() {
        return this.crontab;
    }

    public void init() throws InitializationException {
        try {
            log.info((Object)"TurbineJcrontabSchedulerService init()....starting!");
            String crontabPropertyFile = Turbine.getRealPath((String)Turbine.getConfiguration().getString("services.JCrontab.properties.file"));
            PropertiesConfiguration configuration = new PropertiesConfiguration(crontabPropertyFile);
            configuration.setProperty("applicationRoot", (Object)Turbine.getApplicationRoot());
            log.info((Object)("Starting Crontab with path:" + crontabPropertyFile));
            this.crontab = Crontab.getInstance();
            Properties propObj = ConfigurationConverter.getProperties((Configuration)configuration);
            this.crontab.init(propObj);
            this.setInit(true);
            log.info((Object)"TurbineJcrontabSchedulerService init()....finished!");
        }
        catch (Exception e) {
            throw new InitializationException("TurbineJcrontabSchedulerService failed to initialize", (Throwable)e);
        }
    }

    public void shutdown() {
        try {
            this.crontab.uninit(10);
            log.info((Object)"TurbineJcrontabSchedulerService shutdown()....finished!");
        }
        catch (Exception e) {
            log.error((Object)("Cannot shutdown TurbineJcrontabSchedulerService!: " + e));
        }
    }
}

