/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.avalon;

import java.io.File;
import java.util.Properties;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.jcrontab.Crontab;
import org.jcrontab.avalon.JcrontabScheduler;
import org.jcrontab.data.CrontabEntryDAO;

public class JcrontabSchedulerImpl
extends AbstractLogEnabled
implements JcrontabScheduler,
Configurable,
Initializable,
Contextualizable,
Disposable,
Parameterizable {
    private static final String JCRONTAB_CONFIG_FILE_KEY = "jcrontab-config-file";
    private static final String JCRONTAB_SHUTDOWN_TTW_KEY = "shutdown_time_to_wait";
    private Crontab crontab = null;
    private String applicationRoot;
    private int shutdownTimeToWait;
    private Context context = null;
    private PropertiesConfiguration configuration;
    private boolean start = false;
    private static final String PARAMETER_NAME_START = "start";

    public boolean isRunning() {
        return this.start;
    }

    public Crontab getCrontab() {
        return this.crontab;
    }

    public CrontabEntryDAO getContrabEntryDAO() {
        return CrontabEntryDAO.getInstance();
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.getLogger().info("JCrontabScheduler ....starting!");
        try {
            this.applicationRoot = this.context == null ? null : (String)this.context.get((Object)"componentAppRoot");
        }
        catch (ContextException ce) {
            this.getLogger().error("Could not load Application Root from Context");
        }
        String propertyPath = conf.getChild(JCRONTAB_CONFIG_FILE_KEY, false).getValue();
        this.shutdownTimeToWait = conf.getChild(JCRONTAB_SHUTDOWN_TTW_KEY, true).getValueAsInteger(0);
        File propertyFile = new File(this.applicationRoot, propertyPath).getAbsoluteFile();
        if (!propertyFile.exists()) {
            throw new ConfigurationException("Jcrontab property file " + propertyFile + " doesn't exist.");
        }
        try {
            this.configuration = new PropertiesConfiguration(propertyFile.toString());
            this.configuration.setProperty("applicationRoot", (Object)(this.applicationRoot == null ? "." : this.applicationRoot));
            this.getLogger().info("Starting Crontab with path:" + propertyFile);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not start crontab", (Throwable)e);
        }
        this.getLogger().info("JCrontabScheduler ....started!");
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        if (parameters.isParameter(PARAMETER_NAME_START)) {
            this.start = parameters.getParameterAsBoolean(PARAMETER_NAME_START);
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Using start value: " + this.start);
            }
        } else {
            this.start = true;
        }
    }

    public void initialize() throws Exception {
        Properties properties = ConfigurationConverter.getProperties((org.apache.commons.configuration.Configuration)this.configuration);
        this.crontab = Crontab.getInstance();
        if (this.start) {
            this.crontab.init(properties);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void dispose() {
        this.getLogger().info("JCrontabScheduler ....Shutting down in " + this.shutdownTimeToWait);
        this.crontab.uninit(this.shutdownTimeToWait);
    }
}

