/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.util.Calendar;
import java.util.Date;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.log.Log;

public class CalendarBuilder {
    public CrontabEntryBean getNextCrontabEntry(CrontabEntryBean[] cebs) {
        long[] times = new long[cebs.length];
        int value = 0;
        int index = 0;
        for (int i = 0; i < cebs.length; ++i) {
            times[i] = this.buildCalendar(cebs[i]).getTime();
        }
        long number = times[index];
        for (int i = 0; i < times.length; ++i) {
            if (times[i] >= number) continue;
            number = times[i];
            value = i;
        }
        return cebs[value];
    }

    public Date buildCalendar(CrontabEntryBean ceb) {
        Date now = new Date(System.currentTimeMillis());
        return this.buildCalendar(ceb, now);
    }

    public Date buildCalendar(CrontabEntryBean ceb, Date afterDate) {
        int dayOfMonth;
        int hour;
        int minute;
        Calendar after = Calendar.getInstance();
        after.setTime(afterDate);
        int second = this.getNextIndex(ceb.getBSeconds(), after.get(13));
        if (second == -1) {
            second = this.getNextIndex(ceb.getBSeconds(), 0);
            after.add(12, 1);
        }
        if ((minute = this.getNextIndex(ceb.getBMinutes(), after.get(12))) == -1) {
            second = this.getNextIndex(ceb.getBSeconds(), 0);
            minute = this.getNextIndex(ceb.getBMinutes(), 0);
            after.add(11, 1);
        }
        if ((hour = this.getNextIndex(ceb.getBHours(), after.get(11))) == -1) {
            second = this.getNextIndex(ceb.getBSeconds(), 0);
            minute = this.getNextIndex(ceb.getBMinutes(), 0);
            hour = this.getNextIndex(ceb.getBHours(), 0);
            after.add(5, 1);
        }
        if ((dayOfMonth = this.getNextIndex(ceb.getBDaysOfMonth(), after.get(5) - 1)) == -1) {
            second = this.getNextIndex(ceb.getBSeconds(), 0);
            minute = this.getNextIndex(ceb.getBMinutes(), 0);
            hour = this.getNextIndex(ceb.getBHours(), 0);
            dayOfMonth = this.getNextIndex(ceb.getBDaysOfMonth(), 0);
            after.add(2, 1);
        }
        boolean dayMatchRealDate = false;
        while (!dayMatchRealDate) {
            if (this.checkDayValidInMonth(dayOfMonth + 1, after.get(2), after.get(1))) {
                dayMatchRealDate = true;
                continue;
            }
            after.add(2, 1);
        }
        int month = this.getNextIndex(ceb.getBMonths(), after.get(2));
        if (month == -1) {
            second = this.getNextIndex(ceb.getBSeconds(), 0);
            minute = this.getNextIndex(ceb.getBMinutes(), 0);
            hour = this.getNextIndex(ceb.getBHours(), 0);
            dayOfMonth = this.getNextIndex(ceb.getBDaysOfMonth(), 0);
            month = this.getNextIndex(ceb.getBMonths(), 0);
            after.add(1, 1);
        }
        Date byMonthDays = this.getTime(second, minute, hour, dayOfMonth + 1, month, after.get(1));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(byMonthDays);
        boolean[] bDaysOfWeek = ceb.getBDaysOfWeek();
        if (bDaysOfWeek[calendar.get(7) - 1]) {
            return calendar.getTime();
        }
        calendar.add(6, 1);
        return this.buildCalendar(ceb, calendar.getTime());
    }

    public int getThisYear() {
        Calendar rightNow = Calendar.getInstance();
        return 1;
    }

    private Date getTime(int seconds, int minutes, int hour, int dayOfMonth, int month, int year) {
        try {
            Calendar cl = Calendar.getInstance();
            cl.set(year, month, dayOfMonth, hour, minutes, seconds);
            return cl.getTime();
        }
        catch (Exception e) {
            Log.error("Smth was wrong:", e);
            return null;
        }
    }

    private int getNextIndex(boolean[] array, int start) {
        for (int i = start; i < array.length; ++i) {
            if (!array[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean checkDayValidInMonth(int day, int month, int year) {
        try {
            Calendar cl = Calendar.getInstance();
            cl.setLenient(false);
            cl.set(5, day);
            cl.set(2, month);
            cl.set(1, year);
            cl.getTime();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }
}

