/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.io.IOException;
import java.io.InputStream;
import org.jcrontab.data.DataSource;
import org.jcrontab.data.FileSource;

public class ClassLoaderSource
extends FileSource {
    private static ClassLoaderSource instance;

    public synchronized DataSource getInstance() {
        if (instance == null) {
            instance = new ClassLoaderSource();
        }
        return instance;
    }

    protected InputStream createCrontabStream(String name) throws IOException {
        InputStream input = ClassLoaderSource.class.getClassLoader().getResourceAsStream(name);
        if (input == null) {
            throw new IOException("Resource " + name + " not found");
        }
        return input;
    }

    protected boolean isChanged(String name) {
        boolean rv;
        boolean bl = rv = this.lastModified == 0L;
        if (rv) {
            this.lastModified = System.currentTimeMillis();
        }
        return rv;
    }
}

