/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import org.jcrontab.data.CrontabParser;

public class CrontabEntryBean
implements Serializable {
    private int id = -1;
    private boolean runInBusinessDays = true;
    private String seconds = "0";
    private String hours = "*";
    private String minutes = "*";
    private String months = "*";
    private String daysOfWeek = "*";
    private String daysOfMonth = "*";
    private String years = "*";
    private Date startDate;
    private Date endDate;
    private String className;
    private String methodName = "";
    private String[] extraInfo;
    private boolean bextraInfo = false;
    private String description;
    private boolean[] bHours;
    private boolean[] bSeconds;
    private boolean[] bMinutes;
    private boolean[] bMonths;
    private boolean[] bDaysOfWeek;
    private boolean[] bDaysOfMonth;
    private boolean[] bYears;

    public CrontabEntryBean() {
    }

    public CrontabEntryBean(CrontabEntryBean original) {
        this.setClassName(original.getClassName());
        this.setMethodName(original.getMethodName());
        this.setExtraInfo(original.getExtraInfo());
        this.setHours(original.getHours());
        this.setMinutes(original.getMinutes());
        this.setSeconds(original.getSeconds());
        this.setMonths(original.getMonths());
        this.setDaysOfMonth(original.getDaysOfMonth());
        this.setYears(original.getYears());
        this.setBHours(original.getBHours());
        this.setBMinutes(original.getBMinutes());
        this.setBMonths(original.getBMinutes());
        this.setBDaysOfWeek(original.getBDaysOfMonth());
        this.setBDaysOfMonth(original.getBDaysOfMonth());
        this.setBSeconds(original.getBSeconds());
        this.setBYears(original.getBYears());
        this.setBExtraInfo(original.getBExtraInfo());
        this.setDescription(original.getDescription());
        this.setBusinessDays(original.getBusinessDays());
        this.setStartDate(original.getEndDate());
        this.setEndDate(original.getEndDate());
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setExtraInfo(String[] extraInfo) {
        this.extraInfo = extraInfo;
        this.bextraInfo = true;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(String seconds) {
        this.seconds = seconds;
    }

    public void setMonths(String months) {
        this.months = months;
    }

    public void setDaysOfWeek(String daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public void setDaysOfMonth(String daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    public void setYears(String years) {
        this.years = years;
    }

    public void setBHours(boolean[] bHours) {
        this.bHours = bHours;
    }

    public void setBMinutes(boolean[] bMinutes) {
        this.bMinutes = bMinutes;
    }

    public void setBMonths(boolean[] bMonths) {
        this.bMonths = bMonths;
    }

    public void setBDaysOfWeek(boolean[] bDaysOfWeek) {
        this.bDaysOfWeek = bDaysOfWeek;
    }

    public void setBDaysOfMonth(boolean[] bDaysOfMonth) {
        this.bDaysOfMonth = bDaysOfMonth;
    }

    public void setBSeconds(boolean[] bSeconds) {
        this.bSeconds = bSeconds;
    }

    public void setBYears(boolean[] bYears) {
        this.bYears = bYears;
    }

    public void setBExtraInfo(boolean bextraInfo) {
        this.bextraInfo = bextraInfo;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBusinessDays(boolean runInBusinessDays) {
        this.runInBusinessDays = runInBusinessDays;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public int getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getExtraInfo() {
        return this.extraInfo;
    }

    public String getHours() {
        return this.hours;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public String getMonths() {
        return this.months;
    }

    public boolean[] getBHours() {
        return this.bHours;
    }

    public boolean[] getBMinutes() {
        return this.bMinutes;
    }

    public boolean[] getBMonths() {
        return this.bMonths;
    }

    public boolean[] getBDaysOfWeek() {
        return this.bDaysOfWeek;
    }

    public boolean[] getBDaysOfMonth() {
        return this.bDaysOfMonth;
    }

    public boolean[] getBSeconds() {
        return this.bSeconds;
    }

    public boolean[] getBYears() {
        return this.bYears;
    }

    public boolean getBExtraInfo() {
        return this.bextraInfo;
    }

    public String getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public String getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public String getYears() {
        return this.years;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getBusinessDays() {
        return this.runInBusinessDays;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String toString() {
        try {
            CrontabParser cp = new CrontabParser();
            return cp.unmarshall(this);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public String toXML() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        this.toXML(printWriter);
        return stringWriter.toString();
    }

    public void toXML(PrintWriter pw) {
        pw.println("<crontabentry id=\"" + this.id + "\">");
        pw.println("\t<seconds>" + this.seconds + "</seconds> ");
        pw.println("\t<minutes>" + this.minutes + "</minutes> ");
        pw.println("\t<hours>" + this.hours + "</hours> ");
        pw.println("\t<daysofmonth>" + this.daysOfMonth + "</daysofmonth> ");
        pw.println("\t<months>" + this.months + "</months> ");
        pw.println("\t<daysofweek>" + this.daysOfWeek + "</daysofweek> ");
        pw.println("\t<years>" + this.years + "</years> ");
        pw.println("\t<bussinesdays>" + this.runInBusinessDays + "</bussinesdays> ");
        pw.println("\t<startDate>" + this.startDate + "</startDate> ");
        pw.println("\t<endDate>" + this.endDate + "</endDate> ");
        pw.println("\t<class>" + this.className + "</class> ");
        pw.println("\t<method>" + this.methodName + "</method> ");
        if (this.bextraInfo) {
            pw.print("\t<parameters>");
            for (int i = 0; i < this.extraInfo.length; ++i) {
                pw.print(this.extraInfo[i]);
                if (i >= this.extraInfo.length - 1) continue;
                pw.print(" ");
            }
            pw.println("</parameters>");
        }
        pw.println("\t<description>" + this.description + "</description> ");
        pw.println("</crontabentry>");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Calendar) {
            return this.equalsCalendar((Calendar)obj);
        }
        if (obj instanceof CrontabEntryBean) {
            return this.equalCrontabEntryBean((CrontabEntryBean)obj);
        }
        return false;
    }

    public static CrontabEntryBean[] toArray(Object[] obj) {
        CrontabEntryBean[] ceb = new CrontabEntryBean[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ceb[i] = (CrontabEntryBean)obj[i];
        }
        return ceb;
    }

    private boolean equalsCalendar(Calendar cal) {
        return this.bSeconds[cal.get(13)] && this.bHours[cal.get(11)] && this.bMinutes[cal.get(12)] && this.bMonths[cal.get(2)] && this.bDaysOfWeek[cal.get(7) - 1] && this.bDaysOfMonth[cal.get(5) - 1] && this.bYears[cal.get(1)];
    }

    private boolean equalCrontabEntryBean(CrontabEntryBean ceb) {
        if (this.id != ceb.getId()) {
            return false;
        }
        if (!this.getSeconds().equals(ceb.getSeconds())) {
            return false;
        }
        if (!this.getMinutes().equals(ceb.getMinutes())) {
            return false;
        }
        if (!this.getHours().equals(ceb.getHours())) {
            return false;
        }
        if (!this.getDaysOfWeek().equals(ceb.getDaysOfWeek())) {
            return false;
        }
        if (!this.getDaysOfMonth().equals(ceb.getDaysOfMonth())) {
            return false;
        }
        if (!this.getMonths().equals(ceb.getMonths())) {
            return false;
        }
        if (!this.getYears().equals(ceb.getYears())) {
            return false;
        }
        if (!this.getClassName().equals(ceb.getClassName())) {
            return false;
        }
        if (this.getBExtraInfo() != ceb.getBExtraInfo()) {
            return false;
        }
        if (this.getBusinessDays() != ceb.getBusinessDays()) {
            return false;
        }
        if (this.getBExtraInfo()) {
            if (this.getExtraInfo().length != ceb.getExtraInfo().length) {
                return false;
            }
            for (int i = 0; i < this.getExtraInfo().length; ++i) {
                if (this.getExtraInfo()[i].trim().equals(ceb.getExtraInfo()[i].trim())) continue;
                return false;
            }
        }
        return true;
    }
}

