/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.DataFactory;
import org.jcrontab.data.DataSource;
import org.jcrontab.log.Log;

public class CrontabEntryDAO {
    private static CrontabEntryDAO instance;
    private static DataSource dao;

    private CrontabEntryDAO() {
        if (dao == null) {
            try {
                DataFactory.getInstance();
                dao = DataFactory.getDAO();
            }
            catch (Exception e) {
                Log.error(e.toString(), e);
            }
        }
    }

    public static synchronized CrontabEntryDAO getInstance() {
        if (instance == null) {
            instance = new CrontabEntryDAO();
        }
        return instance;
    }

    public static synchronized CrontabEntryDAO getNewInstance() {
        return new CrontabEntryDAO();
    }

    public CrontabEntryBean[] findAll() throws Exception {
        return dao.findAll();
    }

    public CrontabEntryBean find(CrontabEntryBean ceb) throws Exception {
        return dao.find(ceb);
    }

    public void store(CrontabEntryBean[] list) throws Exception {
        dao.store(list);
    }

    public void store(CrontabEntryBean bean) throws Exception {
        CrontabEntryBean[] cebs = new CrontabEntryBean[]{bean};
        this.store(cebs);
    }

    public void remove(CrontabEntryBean bean) throws Exception {
        CrontabEntryBean[] cebs = new CrontabEntryBean[]{bean};
        this.remove(cebs);
    }

    public void remove(CrontabEntryBean[] list) throws Exception {
        dao.remove(list);
    }

    static {
        dao = null;
    }
}

