/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.util.StringTokenizer;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryException;

public class CrontabParser {
    public CrontabEntryBean marshall(String entry) throws CrontabEntryException {
        boolean[] bHours = new boolean[24];
        boolean[] bMinutes = new boolean[60];
        boolean[] bMonths = new boolean[12];
        boolean[] bDaysOfWeek = new boolean[7];
        boolean[] bDaysOfMonth = new boolean[31];
        CrontabEntryBean ceb = new CrontabEntryBean();
        StringTokenizer tokenizer = new StringTokenizer(entry);
        int numTokens = tokenizer.countTokens();
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            switch (i) {
                case 0: {
                    this.parseToken(token, bMinutes, false);
                    ceb.setBMinutes(bMinutes);
                    ceb.setMinutes(token);
                    break;
                }
                case 1: {
                    this.parseToken(token, bHours, false);
                    ceb.setBHours(bHours);
                    ceb.setHours(token);
                    break;
                }
                case 2: {
                    this.parseToken(token, bDaysOfMonth, true);
                    ceb.setBDaysOfMonth(bDaysOfMonth);
                    ceb.setDaysOfMonth(token);
                    break;
                }
                case 3: {
                    this.parseToken(token, bMonths, true);
                    ceb.setBMonths(bMonths);
                    ceb.setMonths(token);
                    break;
                }
                case 4: {
                    this.parseToken(token, bDaysOfWeek, false);
                    ceb.setBDaysOfWeek(bDaysOfWeek);
                    ceb.setDaysOfWeek(token);
                    break;
                }
                case 5: {
                    try {
                        String className;
                        int index = token.indexOf("#");
                        if (index > 0) {
                            StringTokenizer tokenize = new StringTokenizer(token, "#");
                            className = tokenize.nextToken();
                            String methodName = tokenize.nextToken();
                            ceb.setClassName(className);
                            ceb.setMethodName(methodName);
                            break;
                        }
                        className = token;
                        ceb.setClassName(className);
                        break;
                    }
                    catch (Exception e) {
                        throw new CrontabEntryException(entry);
                    }
                }
                case 6: {
                    String[] extraInfo = new String[numTokens - 6];
                    boolean bextraInfo = true;
                    extraInfo[i - 6] = token;
                    while (tokenizer.hasMoreElements()) {
                        extraInfo[++i - 6] = tokenizer.nextToken();
                    }
                    ceb.setBExtraInfo(bextraInfo);
                    ceb.setExtraInfo(extraInfo);
                    break;
                }
            }
            ++i;
        }
        if (numTokens < 6) {
            throw new CrontabEntryException("The number of items is < 6 at " + entry);
        }
        return this.completeTheMarshalling(ceb);
    }

    public String unmarshall(CrontabEntryBean ceb) throws CrontabEntryException {
        StringBuffer sb = new StringBuffer();
        sb.append(ceb.getMinutes() + " ");
        sb.append(ceb.getHours() + " ");
        sb.append(ceb.getDaysOfMonth() + " ");
        sb.append(ceb.getMonths() + " ");
        sb.append(ceb.getDaysOfWeek() + " ");
        if ("".equals(ceb.getMethodName())) {
            sb.append(ceb.getClassName() + " ");
        } else {
            sb.append(ceb.getClassName() + "#" + ceb.getMethodName() + " ");
        }
        String[] extraInfo = ceb.getExtraInfo();
        if (extraInfo != null) {
            for (int i = 0; i < extraInfo.length; ++i) {
                sb.append(extraInfo[i] + " ");
            }
        }
        return sb.toString();
    }

    public void parseToken(String token, boolean[] arrayBool, boolean bBeginInOne) throws CrontabEntryException {
        int each = 1;
        try {
            int index = token.indexOf("/");
            if (index > 0) {
                each = Integer.parseInt(token.substring(index + 1));
                if (each == 0) {
                    throw new CrontabEntryException("Never use expressions like */0 ");
                }
                token = token.substring(0, index);
            }
            if (token.equals("*")) {
                for (int i = 0; i < arrayBool.length; i += each) {
                    arrayBool[i] = true;
                }
                return;
            }
            index = token.indexOf(",");
            if (index > 0) {
                StringTokenizer tokenizer = new StringTokenizer(token, ",");
                while (tokenizer.hasMoreElements()) {
                    this.parseToken(tokenizer.nextToken(), arrayBool, bBeginInOne);
                }
                return;
            }
            index = token.indexOf("-");
            if (index > 0) {
                int start = Integer.parseInt(token.substring(0, index));
                int end = Integer.parseInt(token.substring(index + 1));
                if (bBeginInOne) {
                    --start;
                    --end;
                }
                for (int j = start; j <= end; j += each) {
                    arrayBool[j] = true;
                }
                return;
            }
            int iValue = Integer.parseInt(token);
            if (bBeginInOne) {
                --iValue;
            }
            arrayBool[iValue] = true;
            return;
        }
        catch (Exception e) {
            throw new CrontabEntryException("Smth was wrong with " + token);
        }
    }

    public CrontabEntryBean completeTheMarshalling(CrontabEntryBean ceb) throws CrontabEntryException {
        if (ceb.getBSeconds() == null) {
            boolean[] bseconds = new boolean[60];
            String seconds = ceb.getSeconds();
            this.parseToken(seconds, bseconds, false);
            ceb.setBSeconds(bseconds);
        }
        if (ceb.getBMinutes() == null) {
            boolean[] bMinutes = new boolean[60];
            String minutes = ceb.getMinutes();
            this.parseToken(minutes, bMinutes, false);
            ceb.setBMinutes(bMinutes);
        }
        if (ceb.getBHours() == null) {
            boolean[] bHours = new boolean[24];
            String hours = ceb.getHours();
            this.parseToken(hours, bHours, false);
            ceb.setBHours(bHours);
        }
        if (ceb.getBDaysOfWeek() == null) {
            boolean[] bDaysOfWeek = new boolean[7];
            String daysOfWeek = ceb.getDaysOfWeek();
            this.parseToken(daysOfWeek, bDaysOfWeek, false);
            ceb.setBDaysOfWeek(bDaysOfWeek);
        }
        if (ceb.getBMonths() == null) {
            boolean[] bMonths = new boolean[12];
            String months = ceb.getMonths();
            this.parseToken(months, bMonths, true);
            ceb.setBMonths(bMonths);
        }
        if (ceb.getBDaysOfMonth() == null) {
            boolean[] bDaysOfMonth = new boolean[31];
            String daysOfMonth = ceb.getDaysOfMonth();
            this.parseToken(daysOfMonth, bDaysOfMonth, true);
            ceb.setBDaysOfMonth(bDaysOfMonth);
        }
        if (ceb.getBYears() == null) {
            boolean[] bYears = new boolean[2500];
            String years = ceb.getYears();
            this.parseToken(years, bYears, false);
            ceb.setBYears(bYears);
        }
        return ceb;
    }
}

