/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;
import org.jcrontab.Crontab;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryException;
import org.jcrontab.data.CrontabParser;
import org.jcrontab.data.DataNotFoundException;
import org.jcrontab.data.DataSource;

public class FileSource
implements DataSource {
    private CrontabParser cp = new CrontabParser();
    private static FileSource instance;
    private CrontabEntryBean[] cachedBeans = null;
    protected long lastModified;
    private String crontab_file = "crontab";

    protected FileSource() {
        if (Crontab.getInstance().getProperty("org.jcrontab.data.file") == null) {
            Crontab.getInstance().setProperty("org.jcrontab.data.file", this.crontab_file);
        }
    }

    public synchronized DataSource getInstance() {
        if (instance == null) {
            instance = new FileSource();
        }
        return instance;
    }

    public synchronized CrontabEntryBean find(CrontabEntryBean ceb) throws CrontabEntryException, IOException, DataNotFoundException {
        CrontabEntryBean[] cebra = this.findAll();
        for (int i = 0; i < cebra.length; ++i) {
            if (!cebra[i].equals(ceb)) continue;
            return cebra[i];
        }
        throw new DataNotFoundException("Unable to find :" + ceb);
    }

    protected InputStream createCrontabStream(String name) throws IOException {
        return new FileInputStream(name);
    }

    public synchronized CrontabEntryBean[] findAll() throws CrontabEntryException, IOException, DataNotFoundException {
        String strLine;
        boolean[] bSeconds = new boolean[60];
        boolean[] bYears = new boolean[10];
        Vector<String> listOfLines = new Vector<String>();
        Vector<CrontabEntryBean> listOfBeans = new Vector<CrontabEntryBean>();
        String filename = Crontab.getInstance().getProperty("org.jcrontab.data.file");
        InputStream fis = this.createCrontabStream(filename);
        BufferedReader input = new BufferedReader(new InputStreamReader(fis));
        while ((strLine = input.readLine()) != null) {
            strLine = strLine.trim();
            listOfLines.add(strLine);
        }
        input.close();
        if (listOfLines.size() > 0) {
            for (int i = 0; i < listOfLines.size(); ++i) {
                String strLines = (String)listOfLines.get(i);
                if (strLines.equals("") || strLines.charAt(0) == '#') continue;
                CrontabEntryBean entry = this.cp.marshall(strLines);
                listOfBeans.add(entry);
            }
        } else {
            throw new DataNotFoundException("No CrontabEntries available");
        }
        int sizeOfBeans = listOfBeans.size();
        if (sizeOfBeans == 0) {
            throw new DataNotFoundException("No CrontabEntries available");
        }
        CrontabEntryBean[] finalBeans = new CrontabEntryBean[sizeOfBeans];
        for (int i = 0; i < sizeOfBeans; ++i) {
            finalBeans[i] = (CrontabEntryBean)listOfBeans.get(i);
            finalBeans[i].setId(i);
        }
        this.cachedBeans = finalBeans;
        return this.cachedBeans;
    }

    public synchronized void remove(CrontabEntryBean[] ceb) throws Exception {
        CrontabEntryBean[] thelist = this.findAll();
        CrontabEntryBean[] result = new CrontabEntryBean[thelist.length - ceb.length];
        for (int i = 0; i < thelist.length; ++i) {
            if (thelist[i] != null) {
                thelist[i].setId(-1);
            }
            for (int y = 0; y < ceb.length; ++y) {
                ceb[y].setId(-1);
                if (thelist[i] == null || !thelist[i].equals(ceb[y])) continue;
                thelist[i] = null;
            }
        }
        int resultCounter = 0;
        for (int i = 0; i < thelist.length; ++i) {
            if (thelist[i] == null) continue;
            result[resultCounter] = thelist[i];
            ++resultCounter;
        }
        this.storeAll(result);
    }

    public synchronized void storeAll(CrontabEntryBean[] list) throws CrontabEntryException, FileNotFoundException, IOException {
        File fl = new File(Crontab.getInstance().getProperty("org.jcrontab.data.file"));
        PrintStream out = new PrintStream(new FileOutputStream(fl));
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            out.println("#");
            out.println(this.cp.unmarshall(list[i]));
        }
        out.println("#");
    }

    public synchronized void store(CrontabEntryBean[] beans) throws CrontabEntryException, IOException, DataNotFoundException {
        CrontabEntryBean[] thelist = null;
        boolean succedded = false;
        try {
            thelist = this.findAll();
            succedded = true;
        }
        catch (Exception e) {
            if (e instanceof DataNotFoundException) {
                this.storeAll(beans);
            }
            throw new DataNotFoundException("Unable to find CrontabEntries");
        }
        if (succedded) {
            int i;
            int size = thelist.length + 1;
            CrontabEntryBean[] resultlist = new CrontabEntryBean[size];
            Vector<CrontabEntryBean> ve = new Vector<CrontabEntryBean>();
            for (i = 0; i < thelist.length; ++i) {
                ve.add(thelist[i]);
            }
            for (i = 0; i < beans.length; ++i) {
                ve.add(beans[i]);
            }
            for (i = 0; i < ve.size(); ++i) {
                resultlist[i] = (CrontabEntryBean)ve.get(i);
            }
            this.storeAll(resultlist);
        }
    }
}

