/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jcrontab.Crontab;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryException;
import org.jcrontab.data.CrontabParser;
import org.jcrontab.data.DataNotFoundException;
import org.jcrontab.data.DataSource;
import org.jcrontab.log.Log;

public class GenericSQLSource
implements DataSource {
    private CrontabParser cp = new CrontabParser();
    private static Object dbDriver = null;
    private static GenericSQLSource instance;
    public static String queryAll;
    public static String querySearching;
    public static String queryStoring;
    public static String queryRemoving;
    public static String nextSequence;

    protected GenericSQLSource() {
    }

    public DataSource getInstance() {
        if (instance == null) {
            instance = new GenericSQLSource();
        }
        return instance;
    }

    public CrontabEntryBean find(CrontabEntryBean ceb) throws CrontabEntryException, ClassNotFoundException, SQLException, DataNotFoundException {
        CrontabEntryBean[] cebra = this.findAll();
        for (int i = 0; i < cebra.length; ++i) {
            if (!cebra[i].equals(ceb)) continue;
            return cebra[i];
        }
        throw new DataNotFoundException("Unable to find :" + ceb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrontabEntryBean[] findAll() throws CrontabEntryException, ClassNotFoundException, SQLException, DataNotFoundException {
        Vector<CrontabEntryBean> list;
        block14: {
            list = new Vector<CrontabEntryBean>();
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                conn = this.getConnection();
                st = conn.createStatement();
                rs = st.executeQuery(queryAll);
                if (rs != null) {
                    while (rs.next()) {
                        boolean[] bSeconds = new boolean[60];
                        boolean[] bYears = new boolean[2500];
                        int id = rs.getInt("id");
                        String second = rs.getString("second");
                        String minute = rs.getString("minute");
                        String hour = rs.getString("hour");
                        String dayofmonth = rs.getString("dayofmonth");
                        String month = rs.getString("month");
                        String dayofweek = rs.getString("dayofweek");
                        String year = rs.getString("year");
                        String task = rs.getString("task");
                        String extrainfo = rs.getString("extrainfo");
                        String line = minute + " " + hour + " " + dayofmonth + " " + month + " " + dayofweek + " " + task + " " + extrainfo;
                        boolean businessDays = rs.getBoolean("businessDays");
                        CrontabEntryBean ceb = this.cp.marshall(line);
                        this.cp.parseToken(year, bYears, false);
                        ceb.setId(id);
                        ceb.setBYears(bYears);
                        ceb.setYears(year);
                        this.cp.parseToken(second, bSeconds, false);
                        ceb.setBSeconds(bSeconds);
                        ceb.setSeconds(second);
                        ceb.setBusinessDays(businessDays);
                        list.add(ceb);
                    }
                    rs.close();
                    break block14;
                }
                throw new DataNotFoundException("No CrontabEntries available");
            }
            finally {
                try {
                    st.close();
                }
                catch (Exception e) {}
                try {
                    conn.close();
                }
                catch (Exception e2) {}
            }
        }
        CrontabEntryBean[] result = new CrontabEntryBean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (CrontabEntryBean)list.get(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CrontabEntryBean[] beans) throws CrontabEntryException, ClassNotFoundException, SQLException {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(queryRemoving);
            for (int i = 0; i < beans.length; ++i) {
                ps.setInt(1, beans[i].getId());
                ps.executeUpdate();
            }
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(CrontabEntryBean[] beans) throws CrontabEntryException, ClassNotFoundException, SQLException {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(queryStoring);
            for (int i = 0; i < beans.length; ++i) {
                if (beans[i].getId() == -1) {
                    this.addId(beans[i], conn);
                }
                ps.setInt(1, beans[i].getId());
                ps.setString(2, beans[i].getSeconds());
                ps.setString(3, beans[i].getMinutes());
                ps.setString(4, beans[i].getHours());
                ps.setString(5, beans[i].getDaysOfMonth());
                ps.setString(6, beans[i].getMonths());
                ps.setString(7, beans[i].getDaysOfWeek());
                ps.setString(8, beans[i].getYears());
                if ("".equals(beans[i].getMethodName())) {
                    ps.setString(9, beans[i].getClassName());
                } else {
                    String classAndMethod = beans[i].getClassName() + "#" + beans[i].getMethodName();
                    ps.setString(9, classAndMethod);
                }
                String[] extraInfo = beans[i].getExtraInfo();
                String extraInfob = new String();
                if (extraInfo.length > 0) {
                    for (int z = 0; z < extraInfo.length; ++z) {
                        extraInfob = extraInfob + " " + extraInfo[z];
                    }
                }
                ps.setString(10, extraInfob);
                ps.setBoolean(11, beans[i].getBusinessDays());
                ps.executeUpdate();
            }
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e2) {}
        }
    }

    protected Connection getConnection() throws SQLException {
        Crontab crontab = Crontab.getInstance();
        String dbUser = crontab.getProperty("org.jcrontab.data.GenericSQLSource.username");
        String dbPwd = crontab.getProperty("org.jcrontab.data.GenericSQLSource.password");
        String dbUrl = crontab.getProperty("org.jcrontab.data.GenericSQLSource.url");
        if (dbDriver == null) {
            dbDriver = this.loadDatabaseDriver(crontab.getProperty("org.jcrontab.data.GenericSQLSource.dbDataSource"));
        }
        if (dbDriver instanceof javax.sql.DataSource) {
            if (dbUser != null && dbPwd != null) {
                return ((javax.sql.DataSource)dbDriver).getConnection(dbUser, dbPwd);
            }
            return ((javax.sql.DataSource)dbDriver).getConnection();
        }
        return DriverManager.getConnection(dbUrl, dbUser, dbPwd);
    }

    protected Object loadDatabaseDriver(String srcName) throws SQLException {
        String dbDataSource = srcName;
        Crontab crontab = Crontab.getInstance();
        if (dbDataSource == null) {
            String dbDriver = crontab.getProperty("org.jcrontab.data.GenericSQLSource.driver");
            Log.info("Loading dbDriver: " + dbDriver);
            try {
                return Class.forName(dbDriver).newInstance();
            }
            catch (Exception ie) {
                Log.error("Error loading " + dbDriver, ie);
                return DriverManager.getDriver(crontab.getProperty("org.jcrontab.data.GenericSQLSource.url"));
            }
        }
        try {
            javax.sql.DataSource dataSource = null;
            Log.info("Loading dataSource: " + dbDataSource);
            InitialContext ctx = null;
            ctx = new InitialContext();
            try {
                dataSource = (javax.sql.DataSource)ctx.lookup(dbDataSource);
            }
            catch (NameNotFoundException nnfe) {
                Log.info(nnfe.getExplanation());
                Log.info("Checking Tomcat Context");
                Context tomcatCtx = (Context)ctx.lookup("java:comp/env");
                dataSource = (javax.sql.DataSource)tomcatCtx.lookup(dbDataSource);
            }
            Log.debug("DataSource loaded. ");
            return dataSource;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e instanceof NamingException) {
                msg = ((NamingException)e).getExplanation();
            }
            Log.debug(msg);
            Log.info(msg + " will try to use dbDriver...");
            return this.loadDatabaseDriver(null);
        }
    }

    private void addId(CrontabEntryBean bean, Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery(nextSequence);
        if (rs != null) {
            while (rs.next()) {
                int id = rs.getInt("id");
                bean.setId(id + 1);
            }
        }
    }

    static {
        queryAll = "SELECT id, second, minute, hour, dayofmonth,  month, dayofweek,  year, task, extrainfo, businessDays  FROM events";
        querySearching = "SELECT id, second, minute, hour,  dayofmonth, month, dayofweek,  year, task, extrainfo, businessDays  FROM events WHERE task = ? ";
        queryStoring = "INSERT INTO events( id, second, minute, hour, dayofmonth, month, dayofweek, year,  task, extrainfo, businessDays)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        queryRemoving = "DELETE FROM events WHERE  id = ? ";
        nextSequence = "SELECT MAX(id) id FROM EVENTS ";
    }
}

