/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.jcrontab.Crontab;
import org.jcrontab.data.HoliDay;
import org.jcrontab.data.HoliDaySource;

public class HoliDayFileSource
implements HoliDaySource {
    private HoliDay[] hol = null;

    public HoliDay[] findAll() throws Exception {
        String strLine;
        if (this.hol != null) {
            return this.hol;
        }
        String filename = Crontab.getInstance().getProperty("org.jcrontab.data.holidaysfilesource");
        String dateFormat = Crontab.getInstance().getProperty("org.jcrontab.data.dateFormat");
        Vector<String> listOfLines = new Vector<String>();
        if (filename == null || filename == "") {
            throw new FileNotFoundException("Should provide a valid filename plz set correctly org.jcrontab.data.holidaysfilesource");
        }
        if (dateFormat == null || dateFormat == "") {
            dateFormat = "dd/MM/yyyy";
        }
        FileInputStream fis = new FileInputStream(filename);
        BufferedReader input = new BufferedReader(new InputStreamReader(fis));
        SimpleDateFormat formater = new SimpleDateFormat(dateFormat);
        while ((strLine = input.readLine()) != null) {
            strLine = strLine.trim();
            listOfLines.add(strLine);
        }
        ((InputStream)fis).close();
        this.hol = new HoliDay[listOfLines.size()];
        for (int i = 0; i < this.hol.length; ++i) {
            HoliDay holiday = new HoliDay();
            holiday.setId(i);
            holiday.setDate(formater.parse((String)listOfLines.get(i)));
            this.hol[i] = holiday;
        }
        return this.hol;
    }
}

