/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.sql.Date;
import org.jcrontab.CronTask;

public class Process {
    private int id;
    private CronTask[] tasksList = null;
    private int counter = 0;
    private boolean isConcurrent = false;
    private boolean isFaultTolerant = false;
    private boolean isRunning = false;
    private Date lastRun = null;

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setTasksList(CronTask[] list) {
        this.tasksList = list;
        this.order();
    }

    public CronTask[] getTasksList() {
        return this.tasksList;
    }

    public void setIsConcurrent(boolean isconcurrent) {
        this.isConcurrent = isconcurrent;
    }

    public void setIsFaultTolerant(boolean isFaultTolerant) {
        this.isFaultTolerant = isFaultTolerant;
    }

    public void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public void setLastRun(Date lastrun) {
        this.lastRun = lastrun;
    }

    public boolean getIsConcurrent() {
        return this.isConcurrent;
    }

    public boolean getIsRunning() {
        return this.isRunning;
    }

    public Date getLastRun() {
        return this.lastRun;
    }

    public void addTask(CronTask task) {
        CronTask[] list = null;
        if (this.counter == 0) {
            list = new CronTask[]{task};
        } else {
            list = new CronTask[this.tasksList.length + 1];
            for (int i = 0; i < this.tasksList.length; ++i) {
                list[i] = this.tasksList[i];
            }
            list[this.tasksList.length] = task;
        }
        this.tasksList = list;
        this.order();
    }

    private void order() {
        CronTask[] orderedList = new CronTask[this.tasksList.length];
        for (int i = 0; i < this.tasksList.length; ++i) {
            orderedList[this.tasksList[i].getOrder()] = this.tasksList[i];
        }
        this.counter = orderedList.length;
        this.tasksList = orderedList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[id: " + this.id + " ]\n ");
        sb.append("[isConcurrent: " + this.isConcurrent + " ]\n ");
        sb.append("[isReentrant: " + this.id + " ]\n ");
        for (int i = 0; i < this.tasksList.length; ++i) {
            sb.append("[Task: " + this.tasksList[i] + " ]\n");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        Process process = null;
        if (!(obj instanceof Process)) {
            return false;
        }
        process = (Process)obj;
        return this.id == process.getId();
    }

    public static Process[] toArray(Object[] obj) {
        Process[] process = new Process[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            process[i] = (Process)obj[i];
        }
        return process;
    }
}

